<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AboInfoTab StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met gegevens van abonnementen
 * @subpackage Structs
 * @date 20240419 package
 */
class AboInfoTab extends AbstractStructBase
{
    /**
     * The abonnement
     * Meta information extracted from the WSDL
     * - documentation: Lijst met gevonden abonnementen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \AbonnementApiV6\StructType\AboInfoRec[]
     */
    public $abonnement;
    /**
     * Constructor method for AboInfoTab
     * @uses AboInfoTab::setAbonnement()
     * @param \AbonnementApiV6\StructType\AboInfoRec[] $abonnement
     */
    public function __construct(array $abonnement = array())
    {
        $this
            ->setAbonnement($abonnement);
    }
    /**
     * Get abonnement value
     * @return \AbonnementApiV6\StructType\AboInfoRec[]|null
     */
    public function getAbonnement()
    {
        return $this->abonnement;
    }
    /**
     * This method is responsible for validating the values passed to the setAbonnement method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAbonnement method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAbonnementForArrayConstraintsFromSetAbonnement(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $aboInfoTabAbonnementItem) {
            // validation for constraint: itemType
            if (!$aboInfoTabAbonnementItem instanceof \AbonnementApiV6\StructType\AboInfoRec) {
                $invalidValues[] = is_object($aboInfoTabAbonnementItem) ? get_class($aboInfoTabAbonnementItem) : sprintf('%s(%s)', gettype($aboInfoTabAbonnementItem), var_export($aboInfoTabAbonnementItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The abonnement property can only contain items of type \AbonnementApiV6\StructType\AboInfoRec, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set abonnement value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\AboInfoRec[] $abonnement
     * @return \AbonnementApiV6\StructType\AboInfoTab
     */
    public function setAbonnement(array $abonnement = array())
    {
        // validation for constraint: array
        if ('' !== ($abonnementArrayErrorMessage = self::validateAbonnementForArrayConstraintsFromSetAbonnement($abonnement))) {
            throw new \InvalidArgumentException($abonnementArrayErrorMessage, __LINE__);
        }
        $this->abonnement = $abonnement;
        return $this;
    }
    /**
     * Add item to abonnement value
     * @throws \InvalidArgumentException
     * @param \AbonnementApiV6\StructType\AboInfoRec $item
     * @return \AbonnementApiV6\StructType\AboInfoTab
     */
    public function addToAbonnement(\AbonnementApiV6\StructType\AboInfoRec $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AbonnementApiV6\StructType\AboInfoRec) {
            throw new \InvalidArgumentException(sprintf('The abonnement property can only contain items of type \AbonnementApiV6\StructType\AboInfoRec, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->abonnement[] = $item;
        return $this;
    }
}
