<?php

namespace AbonnementApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AboInfoRec StructType
 * Meta information extracted from the WSDL
 * - documentation: Gegevens van een abonnement
 * @subpackage Structs
 * @date 20240419 package
 */
class AboInfoRec extends AbstractStructBase
{
    /**
     * The aboNo
     * Meta information extracted from the WSDL
     * - documentation: Nummer van het abonnement
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $aboNo;
    /**
     * The aboRelNoOntvanger
     * Meta information extracted from the WSDL
     * - documentation: Nummer van de abonnee van het abonnement
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $aboRelNoOntvanger;
    /**
     * The aboRelNoBetaler
     * Meta information extracted from the WSDL
     * - documentation: Nummer van de debiteur van het abonnement
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $aboRelNoBetaler;
    /**
     * The uitgaveCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de uitgave van het abonnement
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $uitgaveCode;
    /**
     * The uitgaveNaam
     * Meta information extracted from the WSDL
     * - documentation: Naam van de uitgave van het abonnement
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $uitgaveNaam;
    /**
     * The abosoortCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de abonnementsoort van het abonnement
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $abosoortCode;
    /**
     * The aboStartEditie
     * Meta information extracted from the WSDL
     * - documentation: Editie waarop het abonnement start
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $aboStartEditie;
    /**
     * The aboStartDatum
     * Meta information extracted from the WSDL
     * - documentation: Datum waarop het abonnement start
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $aboStartDatum;
    /**
     * The aboStopEditie
     * Meta information extracted from the WSDL
     * - documentation: Editie waarop het abonnement stopt (laatst te ontvangen editie)
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $aboStopEditie;
    /**
     * The actieCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de actie van het abonnement
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $actieCode;
    /**
     * The pakketCode
     * Meta information extracted from the WSDL
     * - documentation: Code van het pakket van het abonnement
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $pakketCode;
    /**
     * The aboStopDatum
     * Meta information extracted from the WSDL
     * - documentation: Datum waarop het abonnement stopt
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aboStopDatum;
    /**
     * The premiumCodeOntvanger
     * Meta information extracted from the WSDL
     * - documentation: Code van het premium dat de abonnee krijgt
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $premiumCodeOntvanger;
    /**
     * The premiumCodeBetaler
     * Meta information extracted from the WSDL
     * - documentation: Code van het premium dat de debiteur krijgt
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $premiumCodeBetaler;
    /**
     * Constructor method for AboInfoRec
     * @uses AboInfoRec::setAboNo()
     * @uses AboInfoRec::setAboRelNoOntvanger()
     * @uses AboInfoRec::setAboRelNoBetaler()
     * @uses AboInfoRec::setUitgaveCode()
     * @uses AboInfoRec::setUitgaveNaam()
     * @uses AboInfoRec::setAbosoortCode()
     * @uses AboInfoRec::setAboStartEditie()
     * @uses AboInfoRec::setAboStartDatum()
     * @uses AboInfoRec::setAboStopEditie()
     * @uses AboInfoRec::setActieCode()
     * @uses AboInfoRec::setPakketCode()
     * @uses AboInfoRec::setAboStopDatum()
     * @uses AboInfoRec::setPremiumCodeOntvanger()
     * @uses AboInfoRec::setPremiumCodeBetaler()
     * @param float $aboNo
     * @param float $aboRelNoOntvanger
     * @param float $aboRelNoBetaler
     * @param string $uitgaveCode
     * @param string $uitgaveNaam
     * @param string $abosoortCode
     * @param float $aboStartEditie
     * @param string $aboStartDatum
     * @param float $aboStopEditie
     * @param string $actieCode
     * @param string $pakketCode
     * @param string $aboStopDatum
     * @param string $premiumCodeOntvanger
     * @param string $premiumCodeBetaler
     */
    public function __construct($aboNo = null, $aboRelNoOntvanger = null, $aboRelNoBetaler = null, $uitgaveCode = null, $uitgaveNaam = null, $abosoortCode = null, $aboStartEditie = null, $aboStartDatum = null, $aboStopEditie = null, $actieCode = null, $pakketCode = null, $aboStopDatum = null, $premiumCodeOntvanger = null, $premiumCodeBetaler = null)
    {
        $this
            ->setAboNo($aboNo)
            ->setAboRelNoOntvanger($aboRelNoOntvanger)
            ->setAboRelNoBetaler($aboRelNoBetaler)
            ->setUitgaveCode($uitgaveCode)
            ->setUitgaveNaam($uitgaveNaam)
            ->setAbosoortCode($abosoortCode)
            ->setAboStartEditie($aboStartEditie)
            ->setAboStartDatum($aboStartDatum)
            ->setAboStopEditie($aboStopEditie)
            ->setActieCode($actieCode)
            ->setPakketCode($pakketCode)
            ->setAboStopDatum($aboStopDatum)
            ->setPremiumCodeOntvanger($premiumCodeOntvanger)
            ->setPremiumCodeBetaler($premiumCodeBetaler);
    }
    /**
     * Get aboNo value
     * @return float
     */
    public function getAboNo()
    {
        return $this->aboNo;
    }
    /**
     * Set aboNo value
     * @param float $aboNo
     * @return \AbonnementApiV6\StructType\AboInfoRec
     */
    public function setAboNo($aboNo = null)
    {
        // validation for constraint: float
        if (!is_null($aboNo) && !(is_float($aboNo) || is_numeric($aboNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aboNo, true), gettype($aboNo)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($aboNo) && mb_strlen(preg_replace('/(\D)/', '', $aboNo)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($aboNo, true), mb_strlen(preg_replace('/(\D)/', '', $aboNo))), __LINE__);
        }
        $this->aboNo = $aboNo;
        return $this;
    }
    /**
     * Get aboRelNoOntvanger value
     * @return float
     */
    public function getAboRelNoOntvanger()
    {
        return $this->aboRelNoOntvanger;
    }
    /**
     * Set aboRelNoOntvanger value
     * @param float $aboRelNoOntvanger
     * @return \AbonnementApiV6\StructType\AboInfoRec
     */
    public function setAboRelNoOntvanger($aboRelNoOntvanger = null)
    {
        // validation for constraint: float
        if (!is_null($aboRelNoOntvanger) && !(is_float($aboRelNoOntvanger) || is_numeric($aboRelNoOntvanger))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aboRelNoOntvanger, true), gettype($aboRelNoOntvanger)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($aboRelNoOntvanger) && mb_strlen(preg_replace('/(\D)/', '', $aboRelNoOntvanger)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($aboRelNoOntvanger, true), mb_strlen(preg_replace('/(\D)/', '', $aboRelNoOntvanger))), __LINE__);
        }
        $this->aboRelNoOntvanger = $aboRelNoOntvanger;
        return $this;
    }
    /**
     * Get aboRelNoBetaler value
     * @return float
     */
    public function getAboRelNoBetaler()
    {
        return $this->aboRelNoBetaler;
    }
    /**
     * Set aboRelNoBetaler value
     * @param float $aboRelNoBetaler
     * @return \AbonnementApiV6\StructType\AboInfoRec
     */
    public function setAboRelNoBetaler($aboRelNoBetaler = null)
    {
        // validation for constraint: float
        if (!is_null($aboRelNoBetaler) && !(is_float($aboRelNoBetaler) || is_numeric($aboRelNoBetaler))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aboRelNoBetaler, true), gettype($aboRelNoBetaler)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($aboRelNoBetaler) && mb_strlen(preg_replace('/(\D)/', '', $aboRelNoBetaler)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($aboRelNoBetaler, true), mb_strlen(preg_replace('/(\D)/', '', $aboRelNoBetaler))), __LINE__);
        }
        $this->aboRelNoBetaler = $aboRelNoBetaler;
        return $this;
    }
    /**
     * Get uitgaveCode value
     * @return string
     */
    public function getUitgaveCode()
    {
        return $this->uitgaveCode;
    }
    /**
     * Set uitgaveCode value
     * @param string $uitgaveCode
     * @return \AbonnementApiV6\StructType\AboInfoRec
     */
    public function setUitgaveCode($uitgaveCode = null)
    {
        // validation for constraint: string
        if (!is_null($uitgaveCode) && !is_string($uitgaveCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uitgaveCode, true), gettype($uitgaveCode)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($uitgaveCode) && mb_strlen($uitgaveCode) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($uitgaveCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($uitgaveCode) && mb_strlen($uitgaveCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($uitgaveCode)), __LINE__);
        }
        $this->uitgaveCode = $uitgaveCode;
        return $this;
    }
    /**
     * Get uitgaveNaam value
     * @return string
     */
    public function getUitgaveNaam()
    {
        return $this->uitgaveNaam;
    }
    /**
     * Set uitgaveNaam value
     * @param string $uitgaveNaam
     * @return \AbonnementApiV6\StructType\AboInfoRec
     */
    public function setUitgaveNaam($uitgaveNaam = null)
    {
        // validation for constraint: string
        if (!is_null($uitgaveNaam) && !is_string($uitgaveNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uitgaveNaam, true), gettype($uitgaveNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($uitgaveNaam) && mb_strlen($uitgaveNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($uitgaveNaam)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($uitgaveNaam) && mb_strlen($uitgaveNaam) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($uitgaveNaam)), __LINE__);
        }
        $this->uitgaveNaam = $uitgaveNaam;
        return $this;
    }
    /**
     * Get abosoortCode value
     * @return string
     */
    public function getAbosoortCode()
    {
        return $this->abosoortCode;
    }
    /**
     * Set abosoortCode value
     * @param string $abosoortCode
     * @return \AbonnementApiV6\StructType\AboInfoRec
     */
    public function setAbosoortCode($abosoortCode = null)
    {
        // validation for constraint: string
        if (!is_null($abosoortCode) && !is_string($abosoortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abosoortCode, true), gettype($abosoortCode)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($abosoortCode) && mb_strlen($abosoortCode) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($abosoortCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($abosoortCode) && mb_strlen($abosoortCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($abosoortCode)), __LINE__);
        }
        $this->abosoortCode = $abosoortCode;
        return $this;
    }
    /**
     * Get aboStartEditie value
     * @return float
     */
    public function getAboStartEditie()
    {
        return $this->aboStartEditie;
    }
    /**
     * Set aboStartEditie value
     * @param float $aboStartEditie
     * @return \AbonnementApiV6\StructType\AboInfoRec
     */
    public function setAboStartEditie($aboStartEditie = null)
    {
        // validation for constraint: float
        if (!is_null($aboStartEditie) && !(is_float($aboStartEditie) || is_numeric($aboStartEditie))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aboStartEditie, true), gettype($aboStartEditie)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($aboStartEditie) && mb_strlen(preg_replace('/(\D)/', '', $aboStartEditie)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($aboStartEditie, true), mb_strlen(preg_replace('/(\D)/', '', $aboStartEditie))), __LINE__);
        }
        $this->aboStartEditie = $aboStartEditie;
        return $this;
    }
    /**
     * Get aboStartDatum value
     * @return string
     */
    public function getAboStartDatum()
    {
        return $this->aboStartDatum;
    }
    /**
     * Set aboStartDatum value
     * @param string $aboStartDatum
     * @return \AbonnementApiV6\StructType\AboInfoRec
     */
    public function setAboStartDatum($aboStartDatum = null)
    {
        // validation for constraint: string
        if (!is_null($aboStartDatum) && !is_string($aboStartDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboStartDatum, true), gettype($aboStartDatum)), __LINE__);
        }
        $this->aboStartDatum = $aboStartDatum;
        return $this;
    }
    /**
     * Get aboStopEditie value
     * @return float
     */
    public function getAboStopEditie()
    {
        return $this->aboStopEditie;
    }
    /**
     * Set aboStopEditie value
     * @param float $aboStopEditie
     * @return \AbonnementApiV6\StructType\AboInfoRec
     */
    public function setAboStopEditie($aboStopEditie = null)
    {
        // validation for constraint: float
        if (!is_null($aboStopEditie) && !(is_float($aboStopEditie) || is_numeric($aboStopEditie))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aboStopEditie, true), gettype($aboStopEditie)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($aboStopEditie) && mb_strlen(preg_replace('/(\D)/', '', $aboStopEditie)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($aboStopEditie, true), mb_strlen(preg_replace('/(\D)/', '', $aboStopEditie))), __LINE__);
        }
        $this->aboStopEditie = $aboStopEditie;
        return $this;
    }
    /**
     * Get actieCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActieCode()
    {
        return isset($this->actieCode) ? $this->actieCode : null;
    }
    /**
     * Set actieCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actieCode
     * @return \AbonnementApiV6\StructType\AboInfoRec
     */
    public function setActieCode($actieCode = null)
    {
        // validation for constraint: string
        if (!is_null($actieCode) && !is_string($actieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actieCode, true), gettype($actieCode)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($actieCode) && mb_strlen($actieCode) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($actieCode)), __LINE__);
        }
        if (is_null($actieCode) || (is_array($actieCode) && empty($actieCode))) {
            unset($this->actieCode);
        } else {
            $this->actieCode = $actieCode;
        }
        return $this;
    }
    /**
     * Get pakketCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPakketCode()
    {
        return isset($this->pakketCode) ? $this->pakketCode : null;
    }
    /**
     * Set pakketCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pakketCode
     * @return \AbonnementApiV6\StructType\AboInfoRec
     */
    public function setPakketCode($pakketCode = null)
    {
        // validation for constraint: string
        if (!is_null($pakketCode) && !is_string($pakketCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pakketCode, true), gettype($pakketCode)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($pakketCode) && mb_strlen($pakketCode) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($pakketCode)), __LINE__);
        }
        if (is_null($pakketCode) || (is_array($pakketCode) && empty($pakketCode))) {
            unset($this->pakketCode);
        } else {
            $this->pakketCode = $pakketCode;
        }
        return $this;
    }
    /**
     * Get aboStopDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAboStopDatum()
    {
        return isset($this->aboStopDatum) ? $this->aboStopDatum : null;
    }
    /**
     * Set aboStopDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aboStopDatum
     * @return \AbonnementApiV6\StructType\AboInfoRec
     */
    public function setAboStopDatum($aboStopDatum = null)
    {
        // validation for constraint: string
        if (!is_null($aboStopDatum) && !is_string($aboStopDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aboStopDatum, true), gettype($aboStopDatum)), __LINE__);
        }
        if (is_null($aboStopDatum) || (is_array($aboStopDatum) && empty($aboStopDatum))) {
            unset($this->aboStopDatum);
        } else {
            $this->aboStopDatum = $aboStopDatum;
        }
        return $this;
    }
    /**
     * Get premiumCodeOntvanger value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPremiumCodeOntvanger()
    {
        return isset($this->premiumCodeOntvanger) ? $this->premiumCodeOntvanger : null;
    }
    /**
     * Set premiumCodeOntvanger value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $premiumCodeOntvanger
     * @return \AbonnementApiV6\StructType\AboInfoRec
     */
    public function setPremiumCodeOntvanger($premiumCodeOntvanger = null)
    {
        // validation for constraint: string
        if (!is_null($premiumCodeOntvanger) && !is_string($premiumCodeOntvanger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($premiumCodeOntvanger, true), gettype($premiumCodeOntvanger)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($premiumCodeOntvanger) && mb_strlen($premiumCodeOntvanger) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($premiumCodeOntvanger)), __LINE__);
        }
        if (is_null($premiumCodeOntvanger) || (is_array($premiumCodeOntvanger) && empty($premiumCodeOntvanger))) {
            unset($this->premiumCodeOntvanger);
        } else {
            $this->premiumCodeOntvanger = $premiumCodeOntvanger;
        }
        return $this;
    }
    /**
     * Get premiumCodeBetaler value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPremiumCodeBetaler()
    {
        return isset($this->premiumCodeBetaler) ? $this->premiumCodeBetaler : null;
    }
    /**
     * Set premiumCodeBetaler value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $premiumCodeBetaler
     * @return \AbonnementApiV6\StructType\AboInfoRec
     */
    public function setPremiumCodeBetaler($premiumCodeBetaler = null)
    {
        // validation for constraint: string
        if (!is_null($premiumCodeBetaler) && !is_string($premiumCodeBetaler)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($premiumCodeBetaler, true), gettype($premiumCodeBetaler)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($premiumCodeBetaler) && mb_strlen($premiumCodeBetaler) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($premiumCodeBetaler)), __LINE__);
        }
        if (is_null($premiumCodeBetaler) || (is_array($premiumCodeBetaler) && empty($premiumCodeBetaler))) {
            unset($this->premiumCodeBetaler);
        } else {
            $this->premiumCodeBetaler = $premiumCodeBetaler;
        }
        return $this;
    }
}
