<?php

namespace AbonnementApiV6\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Wijk ServiceType
 * @subpackage Services
 * @date 20240419 package
 */
class Wijk extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named wijkCheck
     * Meta information extracted from the WSDL
     * - documentation: Controleert of er een levering mogelijk is voor de uitgave/abonnementsoort/pakket op het opgegeven adres.error182: De combinatie postcode/huisnummer is ongeldigerror183: De uitgave code is ongeldigerror184: De abonnementsoort code is
     * ongeldig of niet gekoppeld aan een uitgaveerror185: De pakketcode is ongeldig of er zijn geen gekoppelde uitgavenerror186: De postcode dient te bestaan uit 4 cijfers gevolgd door een spatie en 2 hoofdletterserror187: Het huisnummer dient geheel te
     * bestaan uit cijferserror188: Teveel parameters tegelijk ingevuld, kies uitgave of abonnementsoort of pakketerror256: De propositie is niet gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\WijkCheckRequest $request_parameters
     * @return \AbonnementApiV6\StructType\WijkCheckResponse|bool
     */
    public function wijkCheck(\AbonnementApiV6\StructType\WijkCheckRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->wijkCheck($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \AbonnementApiV6\StructType\WijkCheckResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
