<?php

namespace AbonnementApiV6\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 * @date 20240419 package
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named updateAboBetaalwijze
     * Meta information extracted from the WSDL
     * - documentation: Een abonnee wil de betaalwijze of het rekeningnummer van zijn bestaande abonnement wijzigen.<br /> In geval het abonnement onderdeel is van een pakket wordt de wijziging voor alle abonnementen behorende tot het pakket doorgevoerd.
     * <br/><u>Let op:</u> bij wijzigingen van een bestaand abonnement dienen alle elementen opnieuw te worden meegegeven. Lege elementen of niet meegegeven (groepen) elementen worden leeg gemaakt door de update.error1: Het abonnement is niet
     * gevondenerror3: De betaalwijze is niet bekenderror4: Bij automatische incasso is een rekeningnummer verplichterror12: Er is geen abonnement opgegevenerror26: Het opgegeven rekeningnummer voldoet nieterror215: Het IBAN nummer is ongeldigerror216: De
     * BIC code is ongeldigerror217: Bij automatische incasso of eenmalige incasso is een IBAN nummer verplichterror218: Het IBAN nummer dient samen met de BIC code opgegeven te wordenerror219: De opgegeven BIC code hoort niet bij het opgegeven IBAN
     * nummererror264: Bij betaalwijze creditcard zijn gegevens van de creditcard verplichterror273: Bij betaalwijze betaling via derden dient de debiteur voor betaling via derden geregistreerd te zijn
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\UpdateAboBetaalwijzeRequest $request_parameters
     * @return \AbonnementApiV6\StructType\UpdateAboBetaalwijzeResponse|bool
     */
    public function updateAboBetaalwijze(\AbonnementApiV6\StructType\UpdateAboBetaalwijzeRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateAboBetaalwijze($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateAboPassword
     * Meta information extracted from the WSDL
     * - documentation: Bijwerken van het wachtwoord bij een abonnement.error1: Het abonnement is niet gevondenerror12: Er is geen abonnement opgegevenerror213: Er is geen wachtwoord opgegeven
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\UpdateAboPasswordRequest $request_parameters
     * @return \AbonnementApiV6\StructType\UpdateAboPasswordResponse|bool
     */
    public function updateAboPassword(\AbonnementApiV6\StructType\UpdateAboPasswordRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateAboPassword($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateLicentie
     * Meta information extracted from the WSDL
     * - documentation: Hoogt het aantal licenties van een licentieabonnement op. <br/><u>Let op:</u> bij wijzigingen van een bestaand abonnement dienen alle elementen opnieuw te worden meegegeven. Lege elementen of niet meegegeven (groepen) elementen
     * worden leeg gemaakt door de update.error1: Het abonnement is niet gevondenerror5: De relatie is niet gevonden.error31: Het e-mail adres voldoet niet aan de eisenerror239: Het abonnement is geen licentieabonnement.error248: Het aantal licenties mag
     * alleen verhoogd worden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\UpdateLicentieRequest $request_parameters
     * @return \AbonnementApiV6\StructType\UpdateLicentieResponse|bool
     */
    public function updateLicentie(\AbonnementApiV6\StructType\UpdateLicentieRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateLicentie($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateKlantPersoon
     * Meta information extracted from the WSDL
     * - documentation: <u><b>Deprecated waarschuwing:</b> Deze operatie zal in een toekomstige webservice versie V6 worden verwijderd. <br/> Als alternatief wordt aangeraden om <b>RelatieApiV6.updatePersoon</b> te gebruiken om de relatie te wijzigen.
     * </br></u> <br/> Werkt een bestaande relatie zijnde een persoon bij op basis van de opgegeven gegevens. <br/><u>Let op:</u> bij wijzigingen van een bestaand persoon dienen alle elementen opnieuw te worden meegegeven. Lege elementen of niet meegegeven
     * (groepen) elementen worden leeg gemaakt door de update.error5: De relatie is niet gevondenerror19: Er is geen relatie opgegevenerror28: Bij een relatie is een naam verplichterror31: Het e-mail adres voldoet niet aan de eisenerror38: Het
     * telefoonnummer is niet geldigerror62: De titulatuur is niet bekenderror63: Het mobiele telefoonnummer is niet geldigerror90: De opgegeven geboortedatum is niet geldigerror215: Het IBAN nummer is ongeldigerror216: De BIC code is ongeldigerror217: Bij
     * automatische incasso of eenmalige incasso is een IBAN nummer verplichterror218: Het IBAN nummer dient samen met de BIC code opgegeven te wordenerror219: De opgegeven BIC code hoort niet bij het opgegeven IBAN nummererror274: Bij ontbreken van NAW
     * gegevens is een e-mail adres verplicht
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\UpdateKlantPersoonRequest $request_parameters
     * @return \AbonnementApiV6\StructType\UpdateKlantPersoonResponse|bool
     */
    public function updateKlantPersoon(\AbonnementApiV6\StructType\UpdateKlantPersoonRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateKlantPersoon($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateKlantAdres
     * Meta information extracted from the WSDL
     * - documentation: <u><b>Deprecated waarschuwing:</b> Deze operatie zal in een toekomstige webservice versie V6 worden verwijderd. <br/> Als alternatief wordt aangeraden om <b>RelatieApiV6.updatePersoon</b> te gebruiken om de relatie te wijzigen.
     * </br></u> <br/> Een klant wil een wijziging maken aan zijn adresgegevens, of een privÃ© of correspondentieadres toevoegen. <br/><u>Let op:</u> bij wijzigingen van een bestaand abonnement dienen alle elementen opnieuw te worden meegegeven. Lege
     * elementen of niet meegegeven (groepen) elementen worden leeg gemaakt door de update.error2: Het land is niet gevondenerror5: De relatie is niet gevondenerror7: Adrestype is niet bekenderror19: Er is geen relatie opgegevenerror30: De adresgegevens
     * zijn niet compleeterror32: De adresgegevens ontbrekenerror66: De provincie is niet gevondenerror69: De provincie is niet gekoppeld aan het landerror72: Voor een provincie is een land verplichterror81: Het adres is niet gevonden in de postcodetabel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\UpdateKlantAdresRequest $request_parameters
     * @return \AbonnementApiV6\StructType\UpdateKlantAdresResponse|bool
     */
    public function updateKlantAdres(\AbonnementApiV6\StructType\UpdateKlantAdresRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateKlantAdres($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateLicentiehouderRol
     * Meta information extracted from the WSDL
     * - documentation: Werkt een rol van een licentiehouder bij naar een andere rolerror1: Het abonnement is niet gevondenerror5: De relatie is niet gevondenerror12: Er is geen abonnement opgegevenerror19: Er is geen relatie opgegevenerror236: De opgegeven
     * rol is niet gevonden bij de uitgave van het abonnementerror238: De licentiehouder is niet gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\UpdateLicentiehouderRolRequest $request_parameters
     * @return \AbonnementApiV6\StructType\UpdateLicentiehouderRolResponse|bool
     */
    public function updateLicentiehouderRol(\AbonnementApiV6\StructType\UpdateLicentiehouderRolRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->updateLicentiehouderRol($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \AbonnementApiV6\StructType\UpdateAboBetaalwijzeResponse|\AbonnementApiV6\StructType\UpdateAboPasswordResponse|\AbonnementApiV6\StructType\UpdateKlantAdresResponse|\AbonnementApiV6\StructType\UpdateKlantPersoonResponse|\AbonnementApiV6\StructType\UpdateLicentiehouderRolResponse|\AbonnementApiV6\StructType\UpdateLicentieResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
