<?php

namespace AbonnementApiV6\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 * @date 20240419 package
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named deleteLicentiehouderRol
     * Meta information extracted from the WSDL
     * - documentation: Verwijdert een rol bij een licentiehoudererror245: Er is geen licentiehouderrol opgegevenerror246: De licentiehouderrol is niet gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\DeleteLicentiehouderRolRequest $request_parameters
     * @return \AbonnementApiV6\StructType\DeleteLicentiehouderRolResponse|bool
     */
    public function deleteLicentiehouderRol(\AbonnementApiV6\StructType\DeleteLicentiehouderRolRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteLicentiehouderRol($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteLicentiehouder
     * Meta information extracted from the WSDL
     * - documentation: Verwijdert een licentiehouder bij een abonnement. Ofwel aboNo en relNo moeten opgegeven worden, ofwel licentiehouderNo moet worden opgegeven.error1: Het abonnement is niet gevondenerror5: De relatie is niet gevondenerror12: Er is
     * geen abonnement opgegevenerror19: Er is geen relatie opgegevenerror244: Er is geen licentiehouder opgegeven
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\DeleteLicentiehouderRequest $request_parameters
     * @return \AbonnementApiV6\StructType\DeleteLicentiehouderResponse|bool
     */
    public function deleteLicentiehouder(\AbonnementApiV6\StructType\DeleteLicentiehouderRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteLicentiehouder($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named deleteToekomstigeMutatie
     * Meta information extracted from the WSDL
     * - documentation: Verwijdert een toekomstige mutatie, zoals een verhuizing of een vakantie regeling.error1: Kan geen relatie vinden, er is geen relNo opgegeven.error2: Kan geen relatie vinden obv de opgegeven relNo.error3: Er is geen toekomstige
     * mutatie nummer opgegeven.error4: Het toekomstige mutatie nummer is niet gevonden.error5: De relatie die de toekomstige mutatie wil verwijderen is niet de relatie waarop de mutatie betrekking heeft.error6: De toekomstige mutatie mag niet worden
     * verwijderd.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AbonnementApiV6\StructType\DeleteToekomstigeMutatieRequest $request_parameters
     * @return \AbonnementApiV6\StructType\DeleteToekomstigeMutatieResponse|bool
     */
    public function deleteToekomstigeMutatie(\AbonnementApiV6\StructType\DeleteToekomstigeMutatieRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteToekomstigeMutatie($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \AbonnementApiV6\StructType\DeleteLicentiehouderResponse|\AbonnementApiV6\StructType\DeleteLicentiehouderRolResponse|\AbonnementApiV6\StructType\DeleteToekomstigeMutatieResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
