<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \RelatieApiV6\ClassMap::get(),
);
/**
 * Samples for Test ServiceType
 */
$test = new \RelatieApiV6\ServiceType\Test($options);
/**
 * Sample call for testConnection operation/method
 */
if ($test->testConnection(new \RelatieApiV6\StructType\TestConnectionRequest()) !== false) {
    print_r($test->getResult());
} else {
    print_r($test->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \RelatieApiV6\ServiceType\Create($options);
/**
 * Sample call for createPersoon operation/method
 */
if ($create->createPersoon(new \RelatieApiV6\StructType\CreatePersoonRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createBedrijf operation/method
 */
if ($create->createBedrijf(new \RelatieApiV6\StructType\CreateBedrijfRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createContactpersoon operation/method
 */
if ($create->createContactpersoon(new \RelatieApiV6\StructType\CreateContactpersoonRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createAfdeling operation/method
 */
if ($create->createAfdeling(new \RelatieApiV6\StructType\CreateAfdelingRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createActiviteit operation/method
 */
if ($create->createActiviteit(new \RelatieApiV6\StructType\CreateActiviteitRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createVerband operation/method
 */
if ($create->createVerband(new \RelatieApiV6\StructType\CreateVerbandRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createKlantKenmerk operation/method
 */
if ($create->createKlantKenmerk(new \RelatieApiV6\StructType\CreateKlantKenmerkRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \RelatieApiV6\ServiceType\Update($options);
/**
 * Sample call for updatePersoon operation/method
 */
if ($update->updatePersoon(new \RelatieApiV6\StructType\UpdatePersoonRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateBedrijf operation/method
 */
if ($update->updateBedrijf(new \RelatieApiV6\StructType\UpdateBedrijfRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateContactpersoon operation/method
 */
if ($update->updateContactpersoon(new \RelatieApiV6\StructType\UpdateContactpersoonRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updatePersoonNrContact operation/method
 */
if ($update->updatePersoonNrContact(new \RelatieApiV6\StructType\UpdatePersoonNrContactRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateContPersoonNrContact operation/method
 */
if ($update->updateContPersoonNrContact(new \RelatieApiV6\StructType\UpdateContPersoonNrContactRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateAfdeling operation/method
 */
if ($update->updateAfdeling(new \RelatieApiV6\StructType\UpdateAfdelingRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updatePassword operation/method
 */
if ($update->updatePassword(new \RelatieApiV6\StructType\UpdatePasswordRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateEmail operation/method
 */
if ($update->updateEmail(new \RelatieApiV6\StructType\UpdateEmailRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateGeboortedatum operation/method
 */
if ($update->updateGeboortedatum(new \RelatieApiV6\StructType\UpdateGeboortedatumRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateRelatiePrivacyStatus operation/method
 */
if ($update->updateRelatiePrivacyStatus(new \RelatieApiV6\StructType\UpdateRelatiePrivacyStatusRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateRelatiePrivacySubCat operation/method
 */
if ($update->updateRelatiePrivacySubCat(new \RelatieApiV6\StructType\UpdateRelatiePrivacySubCatRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \RelatieApiV6\ServiceType\Delete($options);
/**
 * Sample call for deleteContPersoonNrContact operation/method
 */
if ($delete->deleteContPersoonNrContact(new \RelatieApiV6\StructType\DeleteContPersoonNrContactRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteBic operation/method
 */
if ($delete->deleteBic(new \RelatieApiV6\StructType\DeleteBicRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteFunctie operation/method
 */
if ($delete->deleteFunctie(new \RelatieApiV6\StructType\DeleteFunctieRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteVerband operation/method
 */
if ($delete->deleteVerband(new \RelatieApiV6\StructType\DeleteVerbandRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteKlantKenmerk operation/method
 */
if ($delete->deleteKlantKenmerk(new \RelatieApiV6\StructType\DeleteKlantKenmerkRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \RelatieApiV6\ServiceType\Add($options);
/**
 * Sample call for addBic operation/method
 */
if ($add->addBic(new \RelatieApiV6\StructType\AddBicRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addFunctie operation/method
 */
if ($add->addFunctie(new \RelatieApiV6\StructType\AddFunctieRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \RelatieApiV6\ServiceType\Get($options);
/**
 * Sample call for getFuncties operation/method
 */
if ($get->getFuncties(new \RelatieApiV6\StructType\GetFunctiesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBiccodes operation/method
 */
if ($get->getBiccodes(new \RelatieApiV6\StructType\GetBiccodesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getTitulatuurcodes operation/method
 */
if ($get->getTitulatuurcodes(new \RelatieApiV6\StructType\GetTitulatuurcodesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLandcodes operation/method
 */
if ($get->getLandcodes(new \RelatieApiV6\StructType\GetLandcodesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getTaalcodes operation/method
 */
if ($get->getTaalcodes(new \RelatieApiV6\StructType\GetTaalcodesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getProvinciecodes operation/method
 */
if ($get->getProvinciecodes(new \RelatieApiV6\StructType\GetProvinciecodesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRelatietype operation/method
 */
if ($get->getRelatietype(new \RelatieApiV6\StructType\GetRelatietypeRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPersoon operation/method
 */
if ($get->getPersoon(new \RelatieApiV6\StructType\GetPersoonRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPersonen operation/method
 */
if ($get->getPersonen(new \RelatieApiV6\StructType\GetPersonenRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBedrijf operation/method
 */
if ($get->getBedrijf(new \RelatieApiV6\StructType\GetBedrijfRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getContactpersoon operation/method
 */
if ($get->getContactpersoon(new \RelatieApiV6\StructType\GetContactpersoonRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAfdeling operation/method
 */
if ($get->getAfdeling(new \RelatieApiV6\StructType\GetAfdelingRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBedrijfInclCont operation/method
 */
if ($get->getBedrijfInclCont(new \RelatieApiV6\StructType\GetBedrijfInclContRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRelatieKortinggroepen operation/method
 */
if ($get->getRelatieKortinggroepen(new \RelatieApiV6\StructType\GetRelatieKortinggroepenRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getNetnummers operation/method
 */
if ($get->getNetnummers(new \RelatieApiV6\StructType\GetNetnummersRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getActiviteittypen operation/method
 */
if ($get->getActiviteittypen(new \RelatieApiV6\StructType\GetActiviteittypenRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAdres operation/method
 */
if ($get->getAdres(new \RelatieApiV6\StructType\GetAdresRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBicVanIban operation/method
 */
if ($get->getBicVanIban(new \RelatieApiV6\StructType\GetBicVanIbanRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getIbanVanBankrekening operation/method
 */
if ($get->getIbanVanBankrekening(new \RelatieApiV6\StructType\GetIbanVanBankrekeningRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSmartcodeByRelNo operation/method
 */
if ($get->getSmartcodeByRelNo(new \RelatieApiV6\StructType\GetSmartcodeByRelNoRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getKenmerken operation/method
 */
if ($get->getKenmerken(new \RelatieApiV6\StructType\GetKenmerkenRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRelatieManager operation/method
 */
if ($get->getRelatieManager(new \RelatieApiV6\StructType\GetRelatieManagerRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRelatieRayon operation/method
 */
if ($get->getRelatieRayon(new \RelatieApiV6\StructType\GetRelatieRayonRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVerbandInfo operation/method
 */
if ($get->getVerbandInfo(new \RelatieApiV6\StructType\GetVerbandInfoRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getKenmerkInfo operation/method
 */
if ($get->getKenmerkInfo(new \RelatieApiV6\StructType\GetKenmerkInfoRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getKlantKenmerk operation/method
 */
if ($get->getKlantKenmerk(new \RelatieApiV6\StructType\GetKlantKenmerkRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPostcodeInfo operation/method
 */
if ($get->getPostcodeInfo(new \RelatieApiV6\StructType\GetPostcodeInfoRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPrivacyCats operation/method
 */
if ($get->getPrivacyCats(new \RelatieApiV6\StructType\GetPrivacyCatsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPrivacySubCats operation/method
 */
if ($get->getPrivacySubCats(new \RelatieApiV6\StructType\GetPrivacySubCatsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRelatiePrivacyCats operation/method
 */
if ($get->getRelatiePrivacyCats(new \RelatieApiV6\StructType\GetRelatiePrivacyCatsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \RelatieApiV6\ServiceType\Check($options);
/**
 * Sample call for checkEmail operation/method
 */
if ($check->checkEmail(new \RelatieApiV6\StructType\CheckEmailRequest()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for checkCredentials operation/method
 */
if ($check->checkCredentials(new \RelatieApiV6\StructType\CheckCredentialsRequest()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for checkIban operation/method
 */
if ($check->checkIban(new \RelatieApiV6\StructType\CheckIbanRequest()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for checkTelefoon operation/method
 */
if ($check->checkTelefoon(new \RelatieApiV6\StructType\CheckTelefoonRequest()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Search ServiceType
 */
$search = new \RelatieApiV6\ServiceType\Search($options);
/**
 * Sample call for searchEmail operation/method
 */
if ($search->searchEmail(new \RelatieApiV6\StructType\SearchEmailRequest()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for searchBedrijf operation/method
 */
if ($search->searchBedrijf(new \RelatieApiV6\StructType\SearchBedrijfRequest()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for searchNaam operation/method
 */
if ($search->searchNaam(new \RelatieApiV6\StructType\SearchNaamRequest()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for searchPersoon operation/method
 */
if ($search->searchPersoon(new \RelatieApiV6\StructType\SearchPersoonRequest()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for searchBedrijfInclCont operation/method
 */
if ($search->searchBedrijfInclCont(new \RelatieApiV6\StructType\SearchBedrijfInclContRequest()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for searchUsername operation/method
 */
if ($search->searchUsername(new \RelatieApiV6\StructType\SearchUsernameRequest()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for searchSmartcode operation/method
 */
if ($search->searchSmartcode(new \RelatieApiV6\StructType\SearchSmartcodeRequest()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for searchExternNummer operation/method
 */
if ($search->searchExternNummer(new \RelatieApiV6\StructType\SearchExternNummerRequest()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Samples for Generate ServiceType
 */
$generate = new \RelatieApiV6\ServiceType\Generate($options);
/**
 * Sample call for generatePassword operation/method
 */
if ($generate->generatePassword(new \RelatieApiV6\StructType\GeneratePasswordRequest()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \RelatieApiV6\ServiceType\Set($options);
/**
 * Sample call for setOptInOut operation/method
 */
if ($set->setOptInOut(new \RelatieApiV6\StructType\SetOptInOutRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
