<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VrijCheckboxveldRec StructType
 * Meta information extracted from the WSDL
 * - documentation: Vrij checkbox veld
 * @subpackage Structs
 * @date 20240419 package
 */
class VrijCheckboxveldRec extends AbstractStructBase
{
    /**
     * The label
     * Meta information extracted from the WSDL
     * - documentation: Label voor het vrije veld
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $label;
    /**
     * The waarde
     * Meta information extracted from the WSDL
     * - documentation: Waarde van het vrije veld
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $waarde;
    /**
     * Constructor method for VrijCheckboxveldRec
     * @uses VrijCheckboxveldRec::setLabel()
     * @uses VrijCheckboxveldRec::setWaarde()
     * @param string $label
     * @param bool $waarde
     */
    public function __construct($label = null, $waarde = null)
    {
        $this
            ->setLabel($label)
            ->setWaarde($waarde);
    }
    /**
     * Get label value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLabel()
    {
        return isset($this->label) ? $this->label : null;
    }
    /**
     * Set label value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $label
     * @return \RelatieApiV6\StructType\VrijCheckboxveldRec
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($label) && mb_strlen($label) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($label)), __LINE__);
        }
        if (is_null($label) || (is_array($label) && empty($label))) {
            unset($this->label);
        } else {
            $this->label = $label;
        }
        return $this;
    }
    /**
     * Get waarde value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getWaarde()
    {
        return isset($this->waarde) ? $this->waarde : null;
    }
    /**
     * Set waarde value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $waarde
     * @return \RelatieApiV6\StructType\VrijCheckboxveldRec
     */
    public function setWaarde($waarde = null)
    {
        // validation for constraint: boolean
        if (!is_null($waarde) && !is_bool($waarde)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($waarde, true), gettype($waarde)), __LINE__);
        }
        if (is_null($waarde) || (is_array($waarde) && empty($waarde))) {
            unset($this->waarde);
        } else {
            $this->waarde = $waarde;
        }
        return $this;
    }
}
