<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updateRelatiePrivacySubCatRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Wijzigen van de privacy sub categorie van het opgegeven relatienummer, met een verplichte selectie op hoofd categorie en categorie. <u>Let op:</u> Bij updaten van een sub categorie wordt de status opnieuw bepaald o.b.v. de default
 * status van de sub categorie, resp. de categorie (bij lege sub categorie).
 * @subpackage Structs
 * @date 20240419 package
 */
class UpdateRelatiePrivacySubCatRequest extends AbstractStructBase
{
    /**
     * The relNo
     * Meta information extracted from the WSDL
     * - documentation: Relatienummer waarvan de privacy categorieen opgehaald moet worden.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relNo;
    /**
     * The hoofdCatCode
     * Meta information extracted from the WSDL
     * - documentation: De betreffende hoofd privacy categorie.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $hoofdCatCode;
    /**
     * The catCode
     * Meta information extracted from the WSDL
     * - documentation: De betreffende privacy categorie.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $catCode;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The subCatCode
     * Meta information extracted from the WSDL
     * - documentation: De gewenste privacy sub categorie.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $subCatCode;
    /**
     * Constructor method for updateRelatiePrivacySubCatRequest
     * @uses UpdateRelatiePrivacySubCatRequest::setRelNo()
     * @uses UpdateRelatiePrivacySubCatRequest::setHoofdCatCode()
     * @uses UpdateRelatiePrivacySubCatRequest::setCatCode()
     * @uses UpdateRelatiePrivacySubCatRequest::setRequestTag()
     * @uses UpdateRelatiePrivacySubCatRequest::setSubCatCode()
     * @param int $relNo
     * @param string $hoofdCatCode
     * @param string $catCode
     * @param string $requestTag
     * @param string $subCatCode
     */
    public function __construct($relNo = null, $hoofdCatCode = null, $catCode = null, $requestTag = null, $subCatCode = null)
    {
        $this
            ->setRelNo($relNo)
            ->setHoofdCatCode($hoofdCatCode)
            ->setCatCode($catCode)
            ->setRequestTag($requestTag)
            ->setSubCatCode($subCatCode);
    }
    /**
     * Get relNo value
     * @return int
     */
    public function getRelNo()
    {
        return $this->relNo;
    }
    /**
     * Set relNo value
     * @param int $relNo
     * @return \RelatieApiV6\StructType\UpdateRelatiePrivacySubCatRequest
     */
    public function setRelNo($relNo = null)
    {
        // validation for constraint: int
        if (!is_null($relNo) && !(is_int($relNo) || ctype_digit($relNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNo, true), gettype($relNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNo) && mb_strlen(preg_replace('/(\D)/', '', $relNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNo, true), mb_strlen(preg_replace('/(\D)/', '', $relNo))), __LINE__);
        }
        $this->relNo = $relNo;
        return $this;
    }
    /**
     * Get hoofdCatCode value
     * @return string
     */
    public function getHoofdCatCode()
    {
        return $this->hoofdCatCode;
    }
    /**
     * Set hoofdCatCode value
     * @param string $hoofdCatCode
     * @return \RelatieApiV6\StructType\UpdateRelatiePrivacySubCatRequest
     */
    public function setHoofdCatCode($hoofdCatCode = null)
    {
        // validation for constraint: string
        if (!is_null($hoofdCatCode) && !is_string($hoofdCatCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hoofdCatCode, true), gettype($hoofdCatCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($hoofdCatCode) && mb_strlen($hoofdCatCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($hoofdCatCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($hoofdCatCode) && mb_strlen($hoofdCatCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($hoofdCatCode)), __LINE__);
        }
        $this->hoofdCatCode = $hoofdCatCode;
        return $this;
    }
    /**
     * Get catCode value
     * @return string
     */
    public function getCatCode()
    {
        return $this->catCode;
    }
    /**
     * Set catCode value
     * @param string $catCode
     * @return \RelatieApiV6\StructType\UpdateRelatiePrivacySubCatRequest
     */
    public function setCatCode($catCode = null)
    {
        // validation for constraint: string
        if (!is_null($catCode) && !is_string($catCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($catCode, true), gettype($catCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($catCode) && mb_strlen($catCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($catCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($catCode) && mb_strlen($catCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($catCode)), __LINE__);
        }
        $this->catCode = $catCode;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\UpdateRelatiePrivacySubCatRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get subCatCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubCatCode()
    {
        return isset($this->subCatCode) ? $this->subCatCode : null;
    }
    /**
     * Set subCatCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subCatCode
     * @return \RelatieApiV6\StructType\UpdateRelatiePrivacySubCatRequest
     */
    public function setSubCatCode($subCatCode = null)
    {
        // validation for constraint: string
        if (!is_null($subCatCode) && !is_string($subCatCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subCatCode, true), gettype($subCatCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($subCatCode) && mb_strlen($subCatCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($subCatCode)), __LINE__);
        }
        if (is_null($subCatCode) || (is_array($subCatCode) && empty($subCatCode))) {
            unset($this->subCatCode);
        } else {
            $this->subCatCode = $subCatCode;
        }
        return $this;
    }
}
