<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updateRelatiePrivacyStatusRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Wijzigen van de privacy categorie status van het opgegeven relatienummer, met een verplichte selectie op hoofd categorie en categorie.
 * @subpackage Structs
 * @date 20240419 package
 */
class UpdateRelatiePrivacyStatusRequest extends AbstractStructBase
{
    /**
     * The relNo
     * Meta information extracted from the WSDL
     * - documentation: Relatienummer waarvan de privacy categorieen opgehaald moet worden.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relNo;
    /**
     * The hoofdCatCode
     * Meta information extracted from the WSDL
     * - documentation: De betreffende hoofd privacy categorie.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $hoofdCatCode;
    /**
     * The catCode
     * Meta information extracted from the WSDL
     * - documentation: De betreffende privacy categorie.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $catCode;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - documentation: De gewenste privacy categorie status (0=Onbekend , 1=Niet benaderen, 2=Benaderen).
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 3
     * @var int
     */
    public $status;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * Constructor method for updateRelatiePrivacyStatusRequest
     * @uses UpdateRelatiePrivacyStatusRequest::setRelNo()
     * @uses UpdateRelatiePrivacyStatusRequest::setHoofdCatCode()
     * @uses UpdateRelatiePrivacyStatusRequest::setCatCode()
     * @uses UpdateRelatiePrivacyStatusRequest::setStatus()
     * @uses UpdateRelatiePrivacyStatusRequest::setRequestTag()
     * @param int $relNo
     * @param string $hoofdCatCode
     * @param string $catCode
     * @param int $status
     * @param string $requestTag
     */
    public function __construct($relNo = null, $hoofdCatCode = null, $catCode = null, $status = null, $requestTag = null)
    {
        $this
            ->setRelNo($relNo)
            ->setHoofdCatCode($hoofdCatCode)
            ->setCatCode($catCode)
            ->setStatus($status)
            ->setRequestTag($requestTag);
    }
    /**
     * Get relNo value
     * @return int
     */
    public function getRelNo()
    {
        return $this->relNo;
    }
    /**
     * Set relNo value
     * @param int $relNo
     * @return \RelatieApiV6\StructType\UpdateRelatiePrivacyStatusRequest
     */
    public function setRelNo($relNo = null)
    {
        // validation for constraint: int
        if (!is_null($relNo) && !(is_int($relNo) || ctype_digit($relNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNo, true), gettype($relNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNo) && mb_strlen(preg_replace('/(\D)/', '', $relNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNo, true), mb_strlen(preg_replace('/(\D)/', '', $relNo))), __LINE__);
        }
        $this->relNo = $relNo;
        return $this;
    }
    /**
     * Get hoofdCatCode value
     * @return string
     */
    public function getHoofdCatCode()
    {
        return $this->hoofdCatCode;
    }
    /**
     * Set hoofdCatCode value
     * @param string $hoofdCatCode
     * @return \RelatieApiV6\StructType\UpdateRelatiePrivacyStatusRequest
     */
    public function setHoofdCatCode($hoofdCatCode = null)
    {
        // validation for constraint: string
        if (!is_null($hoofdCatCode) && !is_string($hoofdCatCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hoofdCatCode, true), gettype($hoofdCatCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($hoofdCatCode) && mb_strlen($hoofdCatCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($hoofdCatCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($hoofdCatCode) && mb_strlen($hoofdCatCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($hoofdCatCode)), __LINE__);
        }
        $this->hoofdCatCode = $hoofdCatCode;
        return $this;
    }
    /**
     * Get catCode value
     * @return string
     */
    public function getCatCode()
    {
        return $this->catCode;
    }
    /**
     * Set catCode value
     * @param string $catCode
     * @return \RelatieApiV6\StructType\UpdateRelatiePrivacyStatusRequest
     */
    public function setCatCode($catCode = null)
    {
        // validation for constraint: string
        if (!is_null($catCode) && !is_string($catCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($catCode, true), gettype($catCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($catCode) && mb_strlen($catCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($catCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($catCode) && mb_strlen($catCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($catCode)), __LINE__);
        }
        $this->catCode = $catCode;
        return $this;
    }
    /**
     * Get status value
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \RelatieApiV6\StructType\UpdateRelatiePrivacyStatusRequest
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($status) && mb_strlen(preg_replace('/(\D)/', '', $status)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($status, true), mb_strlen(preg_replace('/(\D)/', '', $status))), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\UpdateRelatiePrivacyStatusRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
}
