<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updatePasswordRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Bijwerken van het wachtwoord bij een gebruiker. Dat moet op basis van Ã³f een relatienummer, Ã³f een smartcode
 * @subpackage Structs
 * @date 20240419 package
 */
class UpdatePasswordRequest extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The relatienummer
     * Meta information extracted from the WSDL
     * - documentation: Het relatienummer van de relatie waarvan het wachtwoord bijgewerkt moet worden.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relatienummer;
    /**
     * The smartcode
     * Meta information extracted from the WSDL
     * - documentation: De smartcode van de relatie waarvan het wachtwoord bijgewerkt moet worden.
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $smartcode;
    /**
     * The passwordOud
     * Meta information extracted from the WSDL
     * - documentation: Het oude (huidige) wachtwoord. Hiervan wordt gecontroleerd dat het overeenkomt als deze is meegegeevn
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $passwordOud;
    /**
     * The passwordNieuw
     * Meta information extracted from the WSDL
     * - documentation: Het nieuw in te stellen wachtwoord.
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $passwordNieuw;
    /**
     * The controlePasswordOud
     * Meta information extracted from the WSDL
     * - documentation: Standaard wordt het oude wachtwoord gecontroleerd. Indien controlePasswordOud=false, wordt geen controle uitgevoerd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $controlePasswordOud;
    /**
     * Constructor method for updatePasswordRequest
     * @uses UpdatePasswordRequest::setRequestTag()
     * @uses UpdatePasswordRequest::setRelatienummer()
     * @uses UpdatePasswordRequest::setSmartcode()
     * @uses UpdatePasswordRequest::setPasswordOud()
     * @uses UpdatePasswordRequest::setPasswordNieuw()
     * @uses UpdatePasswordRequest::setControlePasswordOud()
     * @param string $requestTag
     * @param int $relatienummer
     * @param string $smartcode
     * @param string $passwordOud
     * @param string $passwordNieuw
     * @param bool $controlePasswordOud
     */
    public function __construct($requestTag = null, $relatienummer = null, $smartcode = null, $passwordOud = null, $passwordNieuw = null, $controlePasswordOud = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setRelatienummer($relatienummer)
            ->setSmartcode($smartcode)
            ->setPasswordOud($passwordOud)
            ->setPasswordNieuw($passwordNieuw)
            ->setControlePasswordOud($controlePasswordOud);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\UpdatePasswordRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get relatienummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelatienummer()
    {
        return isset($this->relatienummer) ? $this->relatienummer : null;
    }
    /**
     * Set relatienummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relatienummer
     * @return \RelatieApiV6\StructType\UpdatePasswordRequest
     */
    public function setRelatienummer($relatienummer = null)
    {
        // validation for constraint: int
        if (!is_null($relatienummer) && !(is_int($relatienummer) || ctype_digit($relatienummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatienummer, true), gettype($relatienummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatienummer) && mb_strlen(preg_replace('/(\D)/', '', $relatienummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatienummer, true), mb_strlen(preg_replace('/(\D)/', '', $relatienummer))), __LINE__);
        }
        if (is_null($relatienummer) || (is_array($relatienummer) && empty($relatienummer))) {
            unset($this->relatienummer);
        } else {
            $this->relatienummer = $relatienummer;
        }
        return $this;
    }
    /**
     * Get smartcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSmartcode()
    {
        return isset($this->smartcode) ? $this->smartcode : null;
    }
    /**
     * Set smartcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $smartcode
     * @return \RelatieApiV6\StructType\UpdatePasswordRequest
     */
    public function setSmartcode($smartcode = null)
    {
        // validation for constraint: string
        if (!is_null($smartcode) && !is_string($smartcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($smartcode, true), gettype($smartcode)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($smartcode) && mb_strlen($smartcode) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($smartcode)), __LINE__);
        }
        if (is_null($smartcode) || (is_array($smartcode) && empty($smartcode))) {
            unset($this->smartcode);
        } else {
            $this->smartcode = $smartcode;
        }
        return $this;
    }
    /**
     * Get passwordOud value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPasswordOud()
    {
        return isset($this->passwordOud) ? $this->passwordOud : null;
    }
    /**
     * Set passwordOud value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $passwordOud
     * @return \RelatieApiV6\StructType\UpdatePasswordRequest
     */
    public function setPasswordOud($passwordOud = null)
    {
        // validation for constraint: string
        if (!is_null($passwordOud) && !is_string($passwordOud)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passwordOud, true), gettype($passwordOud)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($passwordOud) && mb_strlen($passwordOud) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($passwordOud)), __LINE__);
        }
        if (is_null($passwordOud) || (is_array($passwordOud) && empty($passwordOud))) {
            unset($this->passwordOud);
        } else {
            $this->passwordOud = $passwordOud;
        }
        return $this;
    }
    /**
     * Get passwordNieuw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPasswordNieuw()
    {
        return isset($this->passwordNieuw) ? $this->passwordNieuw : null;
    }
    /**
     * Set passwordNieuw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $passwordNieuw
     * @return \RelatieApiV6\StructType\UpdatePasswordRequest
     */
    public function setPasswordNieuw($passwordNieuw = null)
    {
        // validation for constraint: string
        if (!is_null($passwordNieuw) && !is_string($passwordNieuw)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passwordNieuw, true), gettype($passwordNieuw)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($passwordNieuw) && mb_strlen($passwordNieuw) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($passwordNieuw)), __LINE__);
        }
        if (is_null($passwordNieuw) || (is_array($passwordNieuw) && empty($passwordNieuw))) {
            unset($this->passwordNieuw);
        } else {
            $this->passwordNieuw = $passwordNieuw;
        }
        return $this;
    }
    /**
     * Get controlePasswordOud value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getControlePasswordOud()
    {
        return isset($this->controlePasswordOud) ? $this->controlePasswordOud : null;
    }
    /**
     * Set controlePasswordOud value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $controlePasswordOud
     * @return \RelatieApiV6\StructType\UpdatePasswordRequest
     */
    public function setControlePasswordOud($controlePasswordOud = null)
    {
        // validation for constraint: boolean
        if (!is_null($controlePasswordOud) && !is_bool($controlePasswordOud)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($controlePasswordOud, true), gettype($controlePasswordOud)), __LINE__);
        }
        if (is_null($controlePasswordOud) || (is_array($controlePasswordOud) && empty($controlePasswordOud))) {
            unset($this->controlePasswordOud);
        } else {
            $this->controlePasswordOud = $controlePasswordOud;
        }
        return $this;
    }
}
