<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updateContactpersoonRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Wijzigen van de gegevens van een contactpersoon bij een bedrijf <br/><u>Let op:</u> bij wijzigingen van een bestaande contactpersoon dienen alle elementen opnieuw te worden meegegeven. Lege elementen of niet meegegeven (groepen)
 * elementen worden leeg gemaakt door de update.
 * @subpackage Structs
 * @date 20240419 package
 */
class UpdateContactpersoonRequest extends AbstractStructBase
{
    /**
     * The contactpersoon
     * Meta information extracted from the WSDL
     * - documentation: De gegevens van de contactpersoon
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \RelatieApiV6\StructType\ContactpersoonRec
     */
    public $contactpersoon;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * Constructor method for updateContactpersoonRequest
     * @uses UpdateContactpersoonRequest::setContactpersoon()
     * @uses UpdateContactpersoonRequest::setRequestTag()
     * @param \RelatieApiV6\StructType\ContactpersoonRec $contactpersoon
     * @param string $requestTag
     */
    public function __construct(\RelatieApiV6\StructType\ContactpersoonRec $contactpersoon = null, $requestTag = null)
    {
        $this
            ->setContactpersoon($contactpersoon)
            ->setRequestTag($requestTag);
    }
    /**
     * Get contactpersoon value
     * @return \RelatieApiV6\StructType\ContactpersoonRec
     */
    public function getContactpersoon()
    {
        return $this->contactpersoon;
    }
    /**
     * Set contactpersoon value
     * @param \RelatieApiV6\StructType\ContactpersoonRec $contactpersoon
     * @return \RelatieApiV6\StructType\UpdateContactpersoonRequest
     */
    public function setContactpersoon(\RelatieApiV6\StructType\ContactpersoonRec $contactpersoon = null)
    {
        $this->contactpersoon = $contactpersoon;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\UpdateContactpersoonRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
}
