<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaalcodeRec StructType
 * Meta information extracted from the WSDL
 * - documentation: Taal gegevens
 * @subpackage Structs
 * @date 20240419 package
 */
class TaalcodeRec extends AbstractStructBase
{
    /**
     * The taalCode
     * Meta information extracted from the WSDL
     * - documentation: De code van de taal
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $taalCode;
    /**
     * The taalNaam
     * Meta information extracted from the WSDL
     * - documentation: Naam van de taal
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $taalNaam;
    /**
     * Constructor method for TaalcodeRec
     * @uses TaalcodeRec::setTaalCode()
     * @uses TaalcodeRec::setTaalNaam()
     * @param string $taalCode
     * @param string $taalNaam
     */
    public function __construct($taalCode = null, $taalNaam = null)
    {
        $this
            ->setTaalCode($taalCode)
            ->setTaalNaam($taalNaam);
    }
    /**
     * Get taalCode value
     * @return string
     */
    public function getTaalCode()
    {
        return $this->taalCode;
    }
    /**
     * Set taalCode value
     * @param string $taalCode
     * @return \RelatieApiV6\StructType\TaalcodeRec
     */
    public function setTaalCode($taalCode = null)
    {
        // validation for constraint: string
        if (!is_null($taalCode) && !is_string($taalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taalCode, true), gettype($taalCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($taalCode) && mb_strlen($taalCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($taalCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($taalCode) && mb_strlen($taalCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($taalCode)), __LINE__);
        }
        $this->taalCode = $taalCode;
        return $this;
    }
    /**
     * Get taalNaam value
     * @return string
     */
    public function getTaalNaam()
    {
        return $this->taalNaam;
    }
    /**
     * Set taalNaam value
     * @param string $taalNaam
     * @return \RelatieApiV6\StructType\TaalcodeRec
     */
    public function setTaalNaam($taalNaam = null)
    {
        // validation for constraint: string
        if (!is_null($taalNaam) && !is_string($taalNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taalNaam, true), gettype($taalNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($taalNaam) && mb_strlen($taalNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($taalNaam)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($taalNaam) && mb_strlen($taalNaam) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($taalNaam)), __LINE__);
        }
        $this->taalNaam = $taalNaam;
        return $this;
    }
}
