<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for searchExternNummerRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Geeft het relatienummer terug van de relatie behorende bij het externe nummer
 * @subpackage Structs
 * @date 20240419 package
 */
class SearchExternNummerRequest extends AbstractStructBase
{
    /**
     * The externNummer
     * Meta information extracted from the WSDL
     * - documentation: Het externe nummer dat gezocht moet worden
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $externNummer;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * Constructor method for searchExternNummerRequest
     * @uses SearchExternNummerRequest::setExternNummer()
     * @uses SearchExternNummerRequest::setRequestTag()
     * @param string $externNummer
     * @param string $requestTag
     */
    public function __construct($externNummer = null, $requestTag = null)
    {
        $this
            ->setExternNummer($externNummer)
            ->setRequestTag($requestTag);
    }
    /**
     * Get externNummer value
     * @return string
     */
    public function getExternNummer()
    {
        return $this->externNummer;
    }
    /**
     * Set externNummer value
     * @param string $externNummer
     * @return \RelatieApiV6\StructType\SearchExternNummerRequest
     */
    public function setExternNummer($externNummer = null)
    {
        // validation for constraint: string
        if (!is_null($externNummer) && !is_string($externNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externNummer, true), gettype($externNummer)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($externNummer) && mb_strlen($externNummer) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($externNummer)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($externNummer) && mb_strlen($externNummer) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($externNummer)), __LINE__);
        }
        $this->externNummer = $externNummer;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\SearchExternNummerRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
}
