<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for searchBedrijfRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Zoeken naar bedrijven op basis van postcode + huisnummer
 * @subpackage Structs
 * @date 20240419 package
 */
class SearchBedrijfRequest extends AbstractStructBase
{
    /**
     * The postcode
     * Meta information extracted from the WSDL
     * - documentation: De postcode waarop het bedrijf een adres moet hebben
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $postcode;
    /**
     * The huisnummer
     * Meta information extracted from the WSDL
     * - documentation: Huisnummer waarop het bedrijf een adres moet hebben
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $huisnummer;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The includeAfdelingen
     * Meta information extracted from the WSDL
     * - documentation: Indicatie true= Detailgegevens afdelingen retourneren, false= Geen detailgegevens afdelingen retourneren
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $includeAfdelingen;
    /**
     * The includeContactpersonen
     * Meta information extracted from the WSDL
     * - documentation: Indicatie true= Detailgegevens contactpersonen retourneren, false= Geen detailgegevens contactpersonen retourneren
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $includeContactpersonen;
    /**
     * Constructor method for searchBedrijfRequest
     * @uses SearchBedrijfRequest::setPostcode()
     * @uses SearchBedrijfRequest::setHuisnummer()
     * @uses SearchBedrijfRequest::setRequestTag()
     * @uses SearchBedrijfRequest::setIncludeAfdelingen()
     * @uses SearchBedrijfRequest::setIncludeContactpersonen()
     * @param string $postcode
     * @param string $huisnummer
     * @param string $requestTag
     * @param bool $includeAfdelingen
     * @param bool $includeContactpersonen
     */
    public function __construct($postcode = null, $huisnummer = null, $requestTag = null, $includeAfdelingen = null, $includeContactpersonen = null)
    {
        $this
            ->setPostcode($postcode)
            ->setHuisnummer($huisnummer)
            ->setRequestTag($requestTag)
            ->setIncludeAfdelingen($includeAfdelingen)
            ->setIncludeContactpersonen($includeContactpersonen);
    }
    /**
     * Get postcode value
     * @return string
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \RelatieApiV6\StructType\SearchBedrijfRequest
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($postcode) && mb_strlen($postcode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($postcode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($postcode) && mb_strlen($postcode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get huisnummer value
     * @return string
     */
    public function getHuisnummer()
    {
        return $this->huisnummer;
    }
    /**
     * Set huisnummer value
     * @param string $huisnummer
     * @return \RelatieApiV6\StructType\SearchBedrijfRequest
     */
    public function setHuisnummer($huisnummer = null)
    {
        // validation for constraint: string
        if (!is_null($huisnummer) && !is_string($huisnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($huisnummer, true), gettype($huisnummer)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($huisnummer) && mb_strlen($huisnummer) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($huisnummer)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($huisnummer) && mb_strlen($huisnummer) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($huisnummer)), __LINE__);
        }
        $this->huisnummer = $huisnummer;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\SearchBedrijfRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get includeAfdelingen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeAfdelingen()
    {
        return isset($this->includeAfdelingen) ? $this->includeAfdelingen : null;
    }
    /**
     * Set includeAfdelingen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeAfdelingen
     * @return \RelatieApiV6\StructType\SearchBedrijfRequest
     */
    public function setIncludeAfdelingen($includeAfdelingen = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeAfdelingen) && !is_bool($includeAfdelingen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeAfdelingen, true), gettype($includeAfdelingen)), __LINE__);
        }
        if (is_null($includeAfdelingen) || (is_array($includeAfdelingen) && empty($includeAfdelingen))) {
            unset($this->includeAfdelingen);
        } else {
            $this->includeAfdelingen = $includeAfdelingen;
        }
        return $this;
    }
    /**
     * Get includeContactpersonen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeContactpersonen()
    {
        return isset($this->includeContactpersonen) ? $this->includeContactpersonen : null;
    }
    /**
     * Set includeContactpersonen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeContactpersonen
     * @return \RelatieApiV6\StructType\SearchBedrijfRequest
     */
    public function setIncludeContactpersonen($includeContactpersonen = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeContactpersonen) && !is_bool($includeContactpersonen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeContactpersonen, true), gettype($includeContactpersonen)), __LINE__);
        }
        if (is_null($includeContactpersonen) || (is_array($includeContactpersonen) && empty($includeContactpersonen))) {
            unset($this->includeContactpersonen);
        } else {
            $this->includeContactpersonen = $includeContactpersonen;
        }
        return $this;
    }
}
