<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelatieVerbandInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met verbanden.
 * @subpackage Structs
 * @date 20240419 package
 */
class RelatieVerbandInfo extends AbstractStructBase
{
    /**
     * The verband
     * Meta information extracted from the WSDL
     * - documentation: Lijst met verbanden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \RelatieApiV6\StructType\RelatieVerband[]
     */
    public $verband;
    /**
     * Constructor method for RelatieVerbandInfo
     * @uses RelatieVerbandInfo::setVerband()
     * @param \RelatieApiV6\StructType\RelatieVerband[] $verband
     */
    public function __construct(array $verband = array())
    {
        $this
            ->setVerband($verband);
    }
    /**
     * Get verband value
     * @return \RelatieApiV6\StructType\RelatieVerband[]|null
     */
    public function getVerband()
    {
        return $this->verband;
    }
    /**
     * This method is responsible for validating the values passed to the setVerband method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVerband method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVerbandForArrayConstraintsFromSetVerband(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $relatieVerbandInfoVerbandItem) {
            // validation for constraint: itemType
            if (!$relatieVerbandInfoVerbandItem instanceof \RelatieApiV6\StructType\RelatieVerband) {
                $invalidValues[] = is_object($relatieVerbandInfoVerbandItem) ? get_class($relatieVerbandInfoVerbandItem) : sprintf('%s(%s)', gettype($relatieVerbandInfoVerbandItem), var_export($relatieVerbandInfoVerbandItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The verband property can only contain items of type \RelatieApiV6\StructType\RelatieVerband, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set verband value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV6\StructType\RelatieVerband[] $verband
     * @return \RelatieApiV6\StructType\RelatieVerbandInfo
     */
    public function setVerband(array $verband = array())
    {
        // validation for constraint: array
        if ('' !== ($verbandArrayErrorMessage = self::validateVerbandForArrayConstraintsFromSetVerband($verband))) {
            throw new \InvalidArgumentException($verbandArrayErrorMessage, __LINE__);
        }
        $this->verband = $verband;
        return $this;
    }
    /**
     * Add item to verband value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV6\StructType\RelatieVerband $item
     * @return \RelatieApiV6\StructType\RelatieVerbandInfo
     */
    public function addToVerband(\RelatieApiV6\StructType\RelatieVerband $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RelatieApiV6\StructType\RelatieVerband) {
            throw new \InvalidArgumentException(sprintf('The verband property can only contain items of type \RelatieApiV6\StructType\RelatieVerband, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->verband[] = $item;
        return $this;
    }
}
