<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelatiePrivacyCat StructType
 * Meta information extracted from the WSDL
 * - documentation: Relatie privacy categorie object.
 * @subpackage Structs
 * @date 20240419 package
 */
class RelatiePrivacyCat extends AbstractStructBase
{
    /**
     * The privacyHoofdCatCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de privacy hoofd categorie.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $privacyHoofdCatCode;
    /**
     * The privacyCatCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de privacy categorie.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $privacyCatCode;
    /**
     * The privacyStatus
     * Meta information extracted from the WSDL
     * - documentation: Status van de relatie privacy categorie.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 1
     * @var int
     */
    public $privacyStatus;
    /**
     * The privacyHoofdCatNaam
     * Meta information extracted from the WSDL
     * - documentation: Naam van de privacy hoofd categorie.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $privacyHoofdCatNaam;
    /**
     * The privacyCatNaam
     * Meta information extracted from the WSDL
     * - documentation: Naam van de privacy categorie.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $privacyCatNaam;
    /**
     * The privacySubCatCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de privacy sub categorie.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $privacySubCatCode;
    /**
     * The privacySubCatNaam
     * Meta information extracted from the WSDL
     * - documentation: Naam van de privacy sub categorie.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $privacySubCatNaam;
    /**
     * Constructor method for RelatiePrivacyCat
     * @uses RelatiePrivacyCat::setPrivacyHoofdCatCode()
     * @uses RelatiePrivacyCat::setPrivacyCatCode()
     * @uses RelatiePrivacyCat::setPrivacyStatus()
     * @uses RelatiePrivacyCat::setPrivacyHoofdCatNaam()
     * @uses RelatiePrivacyCat::setPrivacyCatNaam()
     * @uses RelatiePrivacyCat::setPrivacySubCatCode()
     * @uses RelatiePrivacyCat::setPrivacySubCatNaam()
     * @param string $privacyHoofdCatCode
     * @param string $privacyCatCode
     * @param int $privacyStatus
     * @param string $privacyHoofdCatNaam
     * @param string $privacyCatNaam
     * @param string $privacySubCatCode
     * @param string $privacySubCatNaam
     */
    public function __construct($privacyHoofdCatCode = null, $privacyCatCode = null, $privacyStatus = null, $privacyHoofdCatNaam = null, $privacyCatNaam = null, $privacySubCatCode = null, $privacySubCatNaam = null)
    {
        $this
            ->setPrivacyHoofdCatCode($privacyHoofdCatCode)
            ->setPrivacyCatCode($privacyCatCode)
            ->setPrivacyStatus($privacyStatus)
            ->setPrivacyHoofdCatNaam($privacyHoofdCatNaam)
            ->setPrivacyCatNaam($privacyCatNaam)
            ->setPrivacySubCatCode($privacySubCatCode)
            ->setPrivacySubCatNaam($privacySubCatNaam);
    }
    /**
     * Get privacyHoofdCatCode value
     * @return string
     */
    public function getPrivacyHoofdCatCode()
    {
        return $this->privacyHoofdCatCode;
    }
    /**
     * Set privacyHoofdCatCode value
     * @param string $privacyHoofdCatCode
     * @return \RelatieApiV6\StructType\RelatiePrivacyCat
     */
    public function setPrivacyHoofdCatCode($privacyHoofdCatCode = null)
    {
        // validation for constraint: string
        if (!is_null($privacyHoofdCatCode) && !is_string($privacyHoofdCatCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($privacyHoofdCatCode, true), gettype($privacyHoofdCatCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($privacyHoofdCatCode) && mb_strlen($privacyHoofdCatCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($privacyHoofdCatCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($privacyHoofdCatCode) && mb_strlen($privacyHoofdCatCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($privacyHoofdCatCode)), __LINE__);
        }
        $this->privacyHoofdCatCode = $privacyHoofdCatCode;
        return $this;
    }
    /**
     * Get privacyCatCode value
     * @return string
     */
    public function getPrivacyCatCode()
    {
        return $this->privacyCatCode;
    }
    /**
     * Set privacyCatCode value
     * @param string $privacyCatCode
     * @return \RelatieApiV6\StructType\RelatiePrivacyCat
     */
    public function setPrivacyCatCode($privacyCatCode = null)
    {
        // validation for constraint: string
        if (!is_null($privacyCatCode) && !is_string($privacyCatCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($privacyCatCode, true), gettype($privacyCatCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($privacyCatCode) && mb_strlen($privacyCatCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($privacyCatCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($privacyCatCode) && mb_strlen($privacyCatCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($privacyCatCode)), __LINE__);
        }
        $this->privacyCatCode = $privacyCatCode;
        return $this;
    }
    /**
     * Get privacyStatus value
     * @return int
     */
    public function getPrivacyStatus()
    {
        return $this->privacyStatus;
    }
    /**
     * Set privacyStatus value
     * @param int $privacyStatus
     * @return \RelatieApiV6\StructType\RelatiePrivacyCat
     */
    public function setPrivacyStatus($privacyStatus = null)
    {
        // validation for constraint: int
        if (!is_null($privacyStatus) && !(is_int($privacyStatus) || ctype_digit($privacyStatus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($privacyStatus, true), gettype($privacyStatus)), __LINE__);
        }
        // validation for constraint: totalDigits(1)
        if (!is_null($privacyStatus) && mb_strlen(preg_replace('/(\D)/', '', $privacyStatus)) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 1 digits, "%d" given', var_export($privacyStatus, true), mb_strlen(preg_replace('/(\D)/', '', $privacyStatus))), __LINE__);
        }
        $this->privacyStatus = $privacyStatus;
        return $this;
    }
    /**
     * Get privacyHoofdCatNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrivacyHoofdCatNaam()
    {
        return isset($this->privacyHoofdCatNaam) ? $this->privacyHoofdCatNaam : null;
    }
    /**
     * Set privacyHoofdCatNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $privacyHoofdCatNaam
     * @return \RelatieApiV6\StructType\RelatiePrivacyCat
     */
    public function setPrivacyHoofdCatNaam($privacyHoofdCatNaam = null)
    {
        // validation for constraint: string
        if (!is_null($privacyHoofdCatNaam) && !is_string($privacyHoofdCatNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($privacyHoofdCatNaam, true), gettype($privacyHoofdCatNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($privacyHoofdCatNaam) && mb_strlen($privacyHoofdCatNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($privacyHoofdCatNaam)), __LINE__);
        }
        if (is_null($privacyHoofdCatNaam) || (is_array($privacyHoofdCatNaam) && empty($privacyHoofdCatNaam))) {
            unset($this->privacyHoofdCatNaam);
        } else {
            $this->privacyHoofdCatNaam = $privacyHoofdCatNaam;
        }
        return $this;
    }
    /**
     * Get privacyCatNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrivacyCatNaam()
    {
        return isset($this->privacyCatNaam) ? $this->privacyCatNaam : null;
    }
    /**
     * Set privacyCatNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $privacyCatNaam
     * @return \RelatieApiV6\StructType\RelatiePrivacyCat
     */
    public function setPrivacyCatNaam($privacyCatNaam = null)
    {
        // validation for constraint: string
        if (!is_null($privacyCatNaam) && !is_string($privacyCatNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($privacyCatNaam, true), gettype($privacyCatNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($privacyCatNaam) && mb_strlen($privacyCatNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($privacyCatNaam)), __LINE__);
        }
        if (is_null($privacyCatNaam) || (is_array($privacyCatNaam) && empty($privacyCatNaam))) {
            unset($this->privacyCatNaam);
        } else {
            $this->privacyCatNaam = $privacyCatNaam;
        }
        return $this;
    }
    /**
     * Get privacySubCatCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrivacySubCatCode()
    {
        return isset($this->privacySubCatCode) ? $this->privacySubCatCode : null;
    }
    /**
     * Set privacySubCatCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $privacySubCatCode
     * @return \RelatieApiV6\StructType\RelatiePrivacyCat
     */
    public function setPrivacySubCatCode($privacySubCatCode = null)
    {
        // validation for constraint: string
        if (!is_null($privacySubCatCode) && !is_string($privacySubCatCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($privacySubCatCode, true), gettype($privacySubCatCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($privacySubCatCode) && mb_strlen($privacySubCatCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($privacySubCatCode)), __LINE__);
        }
        if (is_null($privacySubCatCode) || (is_array($privacySubCatCode) && empty($privacySubCatCode))) {
            unset($this->privacySubCatCode);
        } else {
            $this->privacySubCatCode = $privacySubCatCode;
        }
        return $this;
    }
    /**
     * Get privacySubCatNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrivacySubCatNaam()
    {
        return isset($this->privacySubCatNaam) ? $this->privacySubCatNaam : null;
    }
    /**
     * Set privacySubCatNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $privacySubCatNaam
     * @return \RelatieApiV6\StructType\RelatiePrivacyCat
     */
    public function setPrivacySubCatNaam($privacySubCatNaam = null)
    {
        // validation for constraint: string
        if (!is_null($privacySubCatNaam) && !is_string($privacySubCatNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($privacySubCatNaam, true), gettype($privacySubCatNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($privacySubCatNaam) && mb_strlen($privacySubCatNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($privacySubCatNaam)), __LINE__);
        }
        if (is_null($privacySubCatNaam) || (is_array($privacySubCatNaam) && empty($privacySubCatNaam))) {
            unset($this->privacySubCatNaam);
        } else {
            $this->privacySubCatNaam = $privacySubCatNaam;
        }
        return $this;
    }
}
