<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelatieKenmerkInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met gevonden kenmerken.
 * @subpackage Structs
 * @date 20240419 package
 */
class RelatieKenmerkInfo extends AbstractStructBase
{
    /**
     * The kenmerk
     * Meta information extracted from the WSDL
     * - documentation: Lijst met gevonden kenmerken.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \RelatieApiV6\StructType\RelatieKenmerk[]
     */
    public $kenmerk;
    /**
     * Constructor method for RelatieKenmerkInfo
     * @uses RelatieKenmerkInfo::setKenmerk()
     * @param \RelatieApiV6\StructType\RelatieKenmerk[] $kenmerk
     */
    public function __construct(array $kenmerk = array())
    {
        $this
            ->setKenmerk($kenmerk);
    }
    /**
     * Get kenmerk value
     * @return \RelatieApiV6\StructType\RelatieKenmerk[]|null
     */
    public function getKenmerk()
    {
        return $this->kenmerk;
    }
    /**
     * This method is responsible for validating the values passed to the setKenmerk method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKenmerk method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKenmerkForArrayConstraintsFromSetKenmerk(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $relatieKenmerkInfoKenmerkItem) {
            // validation for constraint: itemType
            if (!$relatieKenmerkInfoKenmerkItem instanceof \RelatieApiV6\StructType\RelatieKenmerk) {
                $invalidValues[] = is_object($relatieKenmerkInfoKenmerkItem) ? get_class($relatieKenmerkInfoKenmerkItem) : sprintf('%s(%s)', gettype($relatieKenmerkInfoKenmerkItem), var_export($relatieKenmerkInfoKenmerkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kenmerk property can only contain items of type \RelatieApiV6\StructType\RelatieKenmerk, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kenmerk value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV6\StructType\RelatieKenmerk[] $kenmerk
     * @return \RelatieApiV6\StructType\RelatieKenmerkInfo
     */
    public function setKenmerk(array $kenmerk = array())
    {
        // validation for constraint: array
        if ('' !== ($kenmerkArrayErrorMessage = self::validateKenmerkForArrayConstraintsFromSetKenmerk($kenmerk))) {
            throw new \InvalidArgumentException($kenmerkArrayErrorMessage, __LINE__);
        }
        $this->kenmerk = $kenmerk;
        return $this;
    }
    /**
     * Add item to kenmerk value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV6\StructType\RelatieKenmerk $item
     * @return \RelatieApiV6\StructType\RelatieKenmerkInfo
     */
    public function addToKenmerk(\RelatieApiV6\StructType\RelatieKenmerk $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RelatieApiV6\StructType\RelatieKenmerk) {
            throw new \InvalidArgumentException(sprintf('The kenmerk property can only contain items of type \RelatieApiV6\StructType\RelatieKenmerk, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kenmerk[] = $item;
        return $this;
    }
}
