<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelatieBiccodetable StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met aan de relatie gekoppeld bic codes
 * @subpackage Structs
 * @date 20240419 package
 */
class RelatieBiccodetable extends AbstractStructBase
{
    /**
     * The relatieBiccode
     * Meta information extracted from the WSDL
     * - documentation: Bic codes
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \RelatieApiV6\StructType\RelatieBiccodeRec[]
     */
    public $relatieBiccode;
    /**
     * Constructor method for RelatieBiccodetable
     * @uses RelatieBiccodetable::setRelatieBiccode()
     * @param \RelatieApiV6\StructType\RelatieBiccodeRec[] $relatieBiccode
     */
    public function __construct(array $relatieBiccode = array())
    {
        $this
            ->setRelatieBiccode($relatieBiccode);
    }
    /**
     * Get relatieBiccode value
     * @return \RelatieApiV6\StructType\RelatieBiccodeRec[]|null
     */
    public function getRelatieBiccode()
    {
        return $this->relatieBiccode;
    }
    /**
     * This method is responsible for validating the values passed to the setRelatieBiccode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelatieBiccode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelatieBiccodeForArrayConstraintsFromSetRelatieBiccode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $relatieBiccodetableRelatieBiccodeItem) {
            // validation for constraint: itemType
            if (!$relatieBiccodetableRelatieBiccodeItem instanceof \RelatieApiV6\StructType\RelatieBiccodeRec) {
                $invalidValues[] = is_object($relatieBiccodetableRelatieBiccodeItem) ? get_class($relatieBiccodetableRelatieBiccodeItem) : sprintf('%s(%s)', gettype($relatieBiccodetableRelatieBiccodeItem), var_export($relatieBiccodetableRelatieBiccodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The relatieBiccode property can only contain items of type \RelatieApiV6\StructType\RelatieBiccodeRec, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set relatieBiccode value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV6\StructType\RelatieBiccodeRec[] $relatieBiccode
     * @return \RelatieApiV6\StructType\RelatieBiccodetable
     */
    public function setRelatieBiccode(array $relatieBiccode = array())
    {
        // validation for constraint: array
        if ('' !== ($relatieBiccodeArrayErrorMessage = self::validateRelatieBiccodeForArrayConstraintsFromSetRelatieBiccode($relatieBiccode))) {
            throw new \InvalidArgumentException($relatieBiccodeArrayErrorMessage, __LINE__);
        }
        $this->relatieBiccode = $relatieBiccode;
        return $this;
    }
    /**
     * Add item to relatieBiccode value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV6\StructType\RelatieBiccodeRec $item
     * @return \RelatieApiV6\StructType\RelatieBiccodetable
     */
    public function addToRelatieBiccode(\RelatieApiV6\StructType\RelatieBiccodeRec $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RelatieApiV6\StructType\RelatieBiccodeRec) {
            throw new \InvalidArgumentException(sprintf('The relatieBiccode property can only contain items of type \RelatieApiV6\StructType\RelatieBiccodeRec, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->relatieBiccode[] = $item;
        return $this;
    }
}
