<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelatieBiccodeRec StructType
 * Meta information extracted from the WSDL
 * - documentation: Relatie Bic code
 * @subpackage Structs
 * @date 20240419 package
 */
class RelatieBiccodeRec extends AbstractStructBase
{
    /**
     * The relatieBicSleutel
     * Meta information extracted from the WSDL
     * - documentation: Unieke sleutel van de koppeling van de Bic code van de bic categorie aan de relatie
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relatieBicSleutel;
    /**
     * The biccode
     * Meta information extracted from the WSDL
     * - documentation: De gekoppelde bic code
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\BiccodeRec
     */
    public $biccode;
    /**
     * Constructor method for RelatieBiccodeRec
     * @uses RelatieBiccodeRec::setRelatieBicSleutel()
     * @uses RelatieBiccodeRec::setBiccode()
     * @param int $relatieBicSleutel
     * @param \RelatieApiV6\StructType\BiccodeRec $biccode
     */
    public function __construct($relatieBicSleutel = null, \RelatieApiV6\StructType\BiccodeRec $biccode = null)
    {
        $this
            ->setRelatieBicSleutel($relatieBicSleutel)
            ->setBiccode($biccode);
    }
    /**
     * Get relatieBicSleutel value
     * @return int
     */
    public function getRelatieBicSleutel()
    {
        return $this->relatieBicSleutel;
    }
    /**
     * Set relatieBicSleutel value
     * @param int $relatieBicSleutel
     * @return \RelatieApiV6\StructType\RelatieBiccodeRec
     */
    public function setRelatieBicSleutel($relatieBicSleutel = null)
    {
        // validation for constraint: int
        if (!is_null($relatieBicSleutel) && !(is_int($relatieBicSleutel) || ctype_digit($relatieBicSleutel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatieBicSleutel, true), gettype($relatieBicSleutel)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatieBicSleutel) && mb_strlen(preg_replace('/(\D)/', '', $relatieBicSleutel)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatieBicSleutel, true), mb_strlen(preg_replace('/(\D)/', '', $relatieBicSleutel))), __LINE__);
        }
        $this->relatieBicSleutel = $relatieBicSleutel;
        return $this;
    }
    /**
     * Get biccode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\BiccodeRec|null
     */
    public function getBiccode()
    {
        return isset($this->biccode) ? $this->biccode : null;
    }
    /**
     * Set biccode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\BiccodeRec $biccode
     * @return \RelatieApiV6\StructType\RelatieBiccodeRec
     */
    public function setBiccode(\RelatieApiV6\StructType\BiccodeRec $biccode = null)
    {
        if (is_null($biccode) || (is_array($biccode) && empty($biccode))) {
            unset($this->biccode);
        } else {
            $this->biccode = $biccode;
        }
        return $this;
    }
}
