<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrivacyHoofdCat StructType
 * Meta information extracted from the WSDL
 * - documentation: Privacy hoofd categorie object.
 * @subpackage Structs
 * @date 20240419 package
 */
class PrivacyHoofdCat extends AbstractStructBase
{
    /**
     * The privacyHoofdCatCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de privacy hoofd categorie.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $privacyHoofdCatCode;
    /**
     * The privacyHoofdCatNaam
     * Meta information extracted from the WSDL
     * - documentation: Naam van de privacy hoofd categorie.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $privacyHoofdCatNaam;
    /**
     * The privacyCats
     * Meta information extracted from the WSDL
     * - documentation: Lijst van onderliggende privacy categorieen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\PrivacyCatInfo
     */
    public $privacyCats;
    /**
     * Constructor method for PrivacyHoofdCat
     * @uses PrivacyHoofdCat::setPrivacyHoofdCatCode()
     * @uses PrivacyHoofdCat::setPrivacyHoofdCatNaam()
     * @uses PrivacyHoofdCat::setPrivacyCats()
     * @param string $privacyHoofdCatCode
     * @param string $privacyHoofdCatNaam
     * @param \RelatieApiV6\StructType\PrivacyCatInfo $privacyCats
     */
    public function __construct($privacyHoofdCatCode = null, $privacyHoofdCatNaam = null, \RelatieApiV6\StructType\PrivacyCatInfo $privacyCats = null)
    {
        $this
            ->setPrivacyHoofdCatCode($privacyHoofdCatCode)
            ->setPrivacyHoofdCatNaam($privacyHoofdCatNaam)
            ->setPrivacyCats($privacyCats);
    }
    /**
     * Get privacyHoofdCatCode value
     * @return string
     */
    public function getPrivacyHoofdCatCode()
    {
        return $this->privacyHoofdCatCode;
    }
    /**
     * Set privacyHoofdCatCode value
     * @param string $privacyHoofdCatCode
     * @return \RelatieApiV6\StructType\PrivacyHoofdCat
     */
    public function setPrivacyHoofdCatCode($privacyHoofdCatCode = null)
    {
        // validation for constraint: string
        if (!is_null($privacyHoofdCatCode) && !is_string($privacyHoofdCatCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($privacyHoofdCatCode, true), gettype($privacyHoofdCatCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($privacyHoofdCatCode) && mb_strlen($privacyHoofdCatCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($privacyHoofdCatCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($privacyHoofdCatCode) && mb_strlen($privacyHoofdCatCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($privacyHoofdCatCode)), __LINE__);
        }
        $this->privacyHoofdCatCode = $privacyHoofdCatCode;
        return $this;
    }
    /**
     * Get privacyHoofdCatNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrivacyHoofdCatNaam()
    {
        return isset($this->privacyHoofdCatNaam) ? $this->privacyHoofdCatNaam : null;
    }
    /**
     * Set privacyHoofdCatNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $privacyHoofdCatNaam
     * @return \RelatieApiV6\StructType\PrivacyHoofdCat
     */
    public function setPrivacyHoofdCatNaam($privacyHoofdCatNaam = null)
    {
        // validation for constraint: string
        if (!is_null($privacyHoofdCatNaam) && !is_string($privacyHoofdCatNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($privacyHoofdCatNaam, true), gettype($privacyHoofdCatNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($privacyHoofdCatNaam) && mb_strlen($privacyHoofdCatNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($privacyHoofdCatNaam)), __LINE__);
        }
        if (is_null($privacyHoofdCatNaam) || (is_array($privacyHoofdCatNaam) && empty($privacyHoofdCatNaam))) {
            unset($this->privacyHoofdCatNaam);
        } else {
            $this->privacyHoofdCatNaam = $privacyHoofdCatNaam;
        }
        return $this;
    }
    /**
     * Get privacyCats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\PrivacyCatInfo|null
     */
    public function getPrivacyCats()
    {
        return isset($this->privacyCats) ? $this->privacyCats : null;
    }
    /**
     * Set privacyCats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\PrivacyCatInfo $privacyCats
     * @return \RelatieApiV6\StructType\PrivacyHoofdCat
     */
    public function setPrivacyCats(\RelatieApiV6\StructType\PrivacyCatInfo $privacyCats = null)
    {
        if (is_null($privacyCats) || (is_array($privacyCats) && empty($privacyCats))) {
            unset($this->privacyCats);
        } else {
            $this->privacyCats = $privacyCats;
        }
        return $this;
    }
}
