<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Persoontable StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met personen
 * @subpackage Structs
 * @date 20240419 package
 */
class Persoontable extends AbstractStructBase
{
    /**
     * The persoon
     * Meta information extracted from the WSDL
     * - documentation: personen
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \RelatieApiV6\StructType\PersooninfoRec[]
     */
    public $persoon;
    /**
     * Constructor method for Persoontable
     * @uses Persoontable::setPersoon()
     * @param \RelatieApiV6\StructType\PersooninfoRec[] $persoon
     */
    public function __construct(array $persoon = array())
    {
        $this
            ->setPersoon($persoon);
    }
    /**
     * Get persoon value
     * @return \RelatieApiV6\StructType\PersooninfoRec[]|null
     */
    public function getPersoon()
    {
        return $this->persoon;
    }
    /**
     * This method is responsible for validating the values passed to the setPersoon method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPersoon method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePersoonForArrayConstraintsFromSetPersoon(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $persoontablePersoonItem) {
            // validation for constraint: itemType
            if (!$persoontablePersoonItem instanceof \RelatieApiV6\StructType\PersooninfoRec) {
                $invalidValues[] = is_object($persoontablePersoonItem) ? get_class($persoontablePersoonItem) : sprintf('%s(%s)', gettype($persoontablePersoonItem), var_export($persoontablePersoonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The persoon property can only contain items of type \RelatieApiV6\StructType\PersooninfoRec, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set persoon value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV6\StructType\PersooninfoRec[] $persoon
     * @return \RelatieApiV6\StructType\Persoontable
     */
    public function setPersoon(array $persoon = array())
    {
        // validation for constraint: array
        if ('' !== ($persoonArrayErrorMessage = self::validatePersoonForArrayConstraintsFromSetPersoon($persoon))) {
            throw new \InvalidArgumentException($persoonArrayErrorMessage, __LINE__);
        }
        $this->persoon = $persoon;
        return $this;
    }
    /**
     * Add item to persoon value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV6\StructType\PersooninfoRec $item
     * @return \RelatieApiV6\StructType\Persoontable
     */
    public function addToPersoon(\RelatieApiV6\StructType\PersooninfoRec $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RelatieApiV6\StructType\PersooninfoRec) {
            throw new \InvalidArgumentException(sprintf('The persoon property can only contain items of type \RelatieApiV6\StructType\PersooninfoRec, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->persoon[] = $item;
        return $this;
    }
}
