<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Landcodetable StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met beschikbare landcodes
 * @subpackage Structs
 * @date 20240419 package
 */
class Landcodetable extends AbstractStructBase
{
    /**
     * The landcode
     * Meta information extracted from the WSDL
     * - documentation: Landcodes
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \RelatieApiV6\StructType\LandcodeRec[]
     */
    public $landcode;
    /**
     * Constructor method for Landcodetable
     * @uses Landcodetable::setLandcode()
     * @param \RelatieApiV6\StructType\LandcodeRec[] $landcode
     */
    public function __construct(array $landcode = array())
    {
        $this
            ->setLandcode($landcode);
    }
    /**
     * Get landcode value
     * @return \RelatieApiV6\StructType\LandcodeRec[]|null
     */
    public function getLandcode()
    {
        return $this->landcode;
    }
    /**
     * This method is responsible for validating the values passed to the setLandcode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLandcode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLandcodeForArrayConstraintsFromSetLandcode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $landcodetableLandcodeItem) {
            // validation for constraint: itemType
            if (!$landcodetableLandcodeItem instanceof \RelatieApiV6\StructType\LandcodeRec) {
                $invalidValues[] = is_object($landcodetableLandcodeItem) ? get_class($landcodetableLandcodeItem) : sprintf('%s(%s)', gettype($landcodetableLandcodeItem), var_export($landcodetableLandcodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The landcode property can only contain items of type \RelatieApiV6\StructType\LandcodeRec, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set landcode value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV6\StructType\LandcodeRec[] $landcode
     * @return \RelatieApiV6\StructType\Landcodetable
     */
    public function setLandcode(array $landcode = array())
    {
        // validation for constraint: array
        if ('' !== ($landcodeArrayErrorMessage = self::validateLandcodeForArrayConstraintsFromSetLandcode($landcode))) {
            throw new \InvalidArgumentException($landcodeArrayErrorMessage, __LINE__);
        }
        $this->landcode = $landcode;
        return $this;
    }
    /**
     * Add item to landcode value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV6\StructType\LandcodeRec $item
     * @return \RelatieApiV6\StructType\Landcodetable
     */
    public function addToLandcode(\RelatieApiV6\StructType\LandcodeRec $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RelatieApiV6\StructType\LandcodeRec) {
            throw new \InvalidArgumentException(sprintf('The landcode property can only contain items of type \RelatieApiV6\StructType\LandcodeRec, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->landcode[] = $item;
        return $this;
    }
}
