<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LandcodeRec StructType
 * Meta information extracted from the WSDL
 * - documentation: Land gegevens
 * @subpackage Structs
 * @date 20240419 package
 */
class LandcodeRec extends AbstractStructBase
{
    /**
     * The landCode
     * Meta information extracted from the WSDL
     * - documentation: De code van het land
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $landCode;
    /**
     * The landNaam
     * Meta information extracted from the WSDL
     * - documentation: Naam van het land
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $landNaam;
    /**
     * Constructor method for LandcodeRec
     * @uses LandcodeRec::setLandCode()
     * @uses LandcodeRec::setLandNaam()
     * @param string $landCode
     * @param string $landNaam
     */
    public function __construct($landCode = null, $landNaam = null)
    {
        $this
            ->setLandCode($landCode)
            ->setLandNaam($landNaam);
    }
    /**
     * Get landCode value
     * @return string
     */
    public function getLandCode()
    {
        return $this->landCode;
    }
    /**
     * Set landCode value
     * @param string $landCode
     * @return \RelatieApiV6\StructType\LandcodeRec
     */
    public function setLandCode($landCode = null)
    {
        // validation for constraint: string
        if (!is_null($landCode) && !is_string($landCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($landCode, true), gettype($landCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($landCode) && mb_strlen($landCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($landCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($landCode) && mb_strlen($landCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($landCode)), __LINE__);
        }
        $this->landCode = $landCode;
        return $this;
    }
    /**
     * Get landNaam value
     * @return string
     */
    public function getLandNaam()
    {
        return $this->landNaam;
    }
    /**
     * Set landNaam value
     * @param string $landNaam
     * @return \RelatieApiV6\StructType\LandcodeRec
     */
    public function setLandNaam($landNaam = null)
    {
        // validation for constraint: string
        if (!is_null($landNaam) && !is_string($landNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($landNaam, true), gettype($landNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($landNaam) && mb_strlen($landNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($landNaam)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($landNaam) && mb_strlen($landNaam) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($landNaam)), __LINE__);
        }
        $this->landNaam = $landNaam;
        return $this;
    }
}
