<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KenmerkgroepRec StructType
 * Meta information extracted from the WSDL
 * - documentation: Kenmerkgroepen
 * @subpackage Structs
 * @date 20240419 package
 */
class KenmerkgroepRec extends AbstractStructBase
{
    /**
     * The kenmerkgroepCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de kenmerkgroep
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $kenmerkgroepCode;
    /**
     * The kenmerkgroepOmschrijving
     * Meta information extracted from the WSDL
     * - documentation: Omschrijving van het kenmerkgroep
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $kenmerkgroepOmschrijving;
    /**
     * The actief
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $actief;
    /**
     * The hoofdgroepCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de kenmerkhoofdgroep, indien de kenmerkgroep in een hoofdgroep is ingedeeld
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $hoofdgroepCode;
    /**
     * The hoofdgroepOmschrijving
     * Meta information extracted from the WSDL
     * - documentation: Omschrijving van het kenmerkhoofdgroep, indien de kenmerkgroep in een hoofdgroep is ingedeeld
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $hoofdgroepOmschrijving;
    /**
     * The kenmerken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\Kenmerktable
     */
    public $kenmerken;
    /**
     * Constructor method for KenmerkgroepRec
     * @uses KenmerkgroepRec::setKenmerkgroepCode()
     * @uses KenmerkgroepRec::setKenmerkgroepOmschrijving()
     * @uses KenmerkgroepRec::setActief()
     * @uses KenmerkgroepRec::setHoofdgroepCode()
     * @uses KenmerkgroepRec::setHoofdgroepOmschrijving()
     * @uses KenmerkgroepRec::setKenmerken()
     * @param string $kenmerkgroepCode
     * @param string $kenmerkgroepOmschrijving
     * @param bool $actief
     * @param string $hoofdgroepCode
     * @param string $hoofdgroepOmschrijving
     * @param \RelatieApiV6\StructType\Kenmerktable $kenmerken
     */
    public function __construct($kenmerkgroepCode = null, $kenmerkgroepOmschrijving = null, $actief = null, $hoofdgroepCode = null, $hoofdgroepOmschrijving = null, \RelatieApiV6\StructType\Kenmerktable $kenmerken = null)
    {
        $this
            ->setKenmerkgroepCode($kenmerkgroepCode)
            ->setKenmerkgroepOmschrijving($kenmerkgroepOmschrijving)
            ->setActief($actief)
            ->setHoofdgroepCode($hoofdgroepCode)
            ->setHoofdgroepOmschrijving($hoofdgroepOmschrijving)
            ->setKenmerken($kenmerken);
    }
    /**
     * Get kenmerkgroepCode value
     * @return string
     */
    public function getKenmerkgroepCode()
    {
        return $this->kenmerkgroepCode;
    }
    /**
     * Set kenmerkgroepCode value
     * @param string $kenmerkgroepCode
     * @return \RelatieApiV6\StructType\KenmerkgroepRec
     */
    public function setKenmerkgroepCode($kenmerkgroepCode = null)
    {
        // validation for constraint: string
        if (!is_null($kenmerkgroepCode) && !is_string($kenmerkgroepCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kenmerkgroepCode, true), gettype($kenmerkgroepCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($kenmerkgroepCode) && mb_strlen($kenmerkgroepCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($kenmerkgroepCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($kenmerkgroepCode) && mb_strlen($kenmerkgroepCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($kenmerkgroepCode)), __LINE__);
        }
        $this->kenmerkgroepCode = $kenmerkgroepCode;
        return $this;
    }
    /**
     * Get kenmerkgroepOmschrijving value
     * @return string
     */
    public function getKenmerkgroepOmschrijving()
    {
        return $this->kenmerkgroepOmschrijving;
    }
    /**
     * Set kenmerkgroepOmschrijving value
     * @param string $kenmerkgroepOmschrijving
     * @return \RelatieApiV6\StructType\KenmerkgroepRec
     */
    public function setKenmerkgroepOmschrijving($kenmerkgroepOmschrijving = null)
    {
        // validation for constraint: string
        if (!is_null($kenmerkgroepOmschrijving) && !is_string($kenmerkgroepOmschrijving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kenmerkgroepOmschrijving, true), gettype($kenmerkgroepOmschrijving)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($kenmerkgroepOmschrijving) && mb_strlen($kenmerkgroepOmschrijving) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($kenmerkgroepOmschrijving)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($kenmerkgroepOmschrijving) && mb_strlen($kenmerkgroepOmschrijving) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($kenmerkgroepOmschrijving)), __LINE__);
        }
        $this->kenmerkgroepOmschrijving = $kenmerkgroepOmschrijving;
        return $this;
    }
    /**
     * Get actief value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getActief()
    {
        return isset($this->actief) ? $this->actief : null;
    }
    /**
     * Set actief value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $actief
     * @return \RelatieApiV6\StructType\KenmerkgroepRec
     */
    public function setActief($actief = null)
    {
        // validation for constraint: boolean
        if (!is_null($actief) && !is_bool($actief)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($actief, true), gettype($actief)), __LINE__);
        }
        if (is_null($actief) || (is_array($actief) && empty($actief))) {
            unset($this->actief);
        } else {
            $this->actief = $actief;
        }
        return $this;
    }
    /**
     * Get hoofdgroepCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHoofdgroepCode()
    {
        return isset($this->hoofdgroepCode) ? $this->hoofdgroepCode : null;
    }
    /**
     * Set hoofdgroepCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hoofdgroepCode
     * @return \RelatieApiV6\StructType\KenmerkgroepRec
     */
    public function setHoofdgroepCode($hoofdgroepCode = null)
    {
        // validation for constraint: string
        if (!is_null($hoofdgroepCode) && !is_string($hoofdgroepCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hoofdgroepCode, true), gettype($hoofdgroepCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($hoofdgroepCode) && mb_strlen($hoofdgroepCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($hoofdgroepCode)), __LINE__);
        }
        if (is_null($hoofdgroepCode) || (is_array($hoofdgroepCode) && empty($hoofdgroepCode))) {
            unset($this->hoofdgroepCode);
        } else {
            $this->hoofdgroepCode = $hoofdgroepCode;
        }
        return $this;
    }
    /**
     * Get hoofdgroepOmschrijving value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHoofdgroepOmschrijving()
    {
        return isset($this->hoofdgroepOmschrijving) ? $this->hoofdgroepOmschrijving : null;
    }
    /**
     * Set hoofdgroepOmschrijving value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hoofdgroepOmschrijving
     * @return \RelatieApiV6\StructType\KenmerkgroepRec
     */
    public function setHoofdgroepOmschrijving($hoofdgroepOmschrijving = null)
    {
        // validation for constraint: string
        if (!is_null($hoofdgroepOmschrijving) && !is_string($hoofdgroepOmschrijving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hoofdgroepOmschrijving, true), gettype($hoofdgroepOmschrijving)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($hoofdgroepOmschrijving) && mb_strlen($hoofdgroepOmschrijving) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($hoofdgroepOmschrijving)), __LINE__);
        }
        if (is_null($hoofdgroepOmschrijving) || (is_array($hoofdgroepOmschrijving) && empty($hoofdgroepOmschrijving))) {
            unset($this->hoofdgroepOmschrijving);
        } else {
            $this->hoofdgroepOmschrijving = $hoofdgroepOmschrijving;
        }
        return $this;
    }
    /**
     * Get kenmerken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\Kenmerktable|null
     */
    public function getKenmerken()
    {
        return isset($this->kenmerken) ? $this->kenmerken : null;
    }
    /**
     * Set kenmerken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\Kenmerktable $kenmerken
     * @return \RelatieApiV6\StructType\KenmerkgroepRec
     */
    public function setKenmerken(\RelatieApiV6\StructType\Kenmerktable $kenmerken = null)
    {
        if (is_null($kenmerken) || (is_array($kenmerken) && empty($kenmerken))) {
            unset($this->kenmerken);
        } else {
            $this->kenmerken = $kenmerken;
        }
        return $this;
    }
}
