<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getTaalcodesResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: error105: Er zijn geen Taalcodes gevonden
 * @subpackage Structs
 * @date 20240419 package
 */
class GetTaalcodesResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The taalCodes
     * Meta information extracted from the WSDL
     * - documentation: De beschikbare taal codes
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\Taalcodetable
     */
    public $taalCodes;
    /**
     * Constructor method for getTaalcodesResponse
     * @uses GetTaalcodesResponse::setRequestTag()
     * @uses GetTaalcodesResponse::setTaalCodes()
     * @param string $requestTag
     * @param \RelatieApiV6\StructType\Taalcodetable $taalCodes
     */
    public function __construct($requestTag = null, \RelatieApiV6\StructType\Taalcodetable $taalCodes = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setTaalCodes($taalCodes);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\GetTaalcodesResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get taalCodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\Taalcodetable|null
     */
    public function getTaalCodes()
    {
        return isset($this->taalCodes) ? $this->taalCodes : null;
    }
    /**
     * Set taalCodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\Taalcodetable $taalCodes
     * @return \RelatieApiV6\StructType\GetTaalcodesResponse
     */
    public function setTaalCodes(\RelatieApiV6\StructType\Taalcodetable $taalCodes = null)
    {
        if (is_null($taalCodes) || (is_array($taalCodes) && empty($taalCodes))) {
            unset($this->taalCodes);
        } else {
            $this->taalCodes = $taalCodes;
        }
        return $this;
    }
}
