<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getPrivacySubCatsRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Ophalen van stamgegevens voor mogelijk privacy sub categorieen, met een verplichte selectie op hoofd categorie en categorie. Alleen de privacy sub categorieen worden opgehaald.
 * @subpackage Structs
 * @date 20240419 package
 */
class GetPrivacySubCatsRequest extends AbstractStructBase
{
    /**
     * The hoofdCatCode
     * Meta information extracted from the WSDL
     * - documentation: De hoofd privacy categorie.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $hoofdCatCode;
    /**
     * The catCode
     * Meta information extracted from the WSDL
     * - documentation: De privacy categorie.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $catCode;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * Constructor method for getPrivacySubCatsRequest
     * @uses GetPrivacySubCatsRequest::setHoofdCatCode()
     * @uses GetPrivacySubCatsRequest::setCatCode()
     * @uses GetPrivacySubCatsRequest::setRequestTag()
     * @param string $hoofdCatCode
     * @param string $catCode
     * @param string $requestTag
     */
    public function __construct($hoofdCatCode = null, $catCode = null, $requestTag = null)
    {
        $this
            ->setHoofdCatCode($hoofdCatCode)
            ->setCatCode($catCode)
            ->setRequestTag($requestTag);
    }
    /**
     * Get hoofdCatCode value
     * @return string
     */
    public function getHoofdCatCode()
    {
        return $this->hoofdCatCode;
    }
    /**
     * Set hoofdCatCode value
     * @param string $hoofdCatCode
     * @return \RelatieApiV6\StructType\GetPrivacySubCatsRequest
     */
    public function setHoofdCatCode($hoofdCatCode = null)
    {
        // validation for constraint: string
        if (!is_null($hoofdCatCode) && !is_string($hoofdCatCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hoofdCatCode, true), gettype($hoofdCatCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($hoofdCatCode) && mb_strlen($hoofdCatCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($hoofdCatCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($hoofdCatCode) && mb_strlen($hoofdCatCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($hoofdCatCode)), __LINE__);
        }
        $this->hoofdCatCode = $hoofdCatCode;
        return $this;
    }
    /**
     * Get catCode value
     * @return string
     */
    public function getCatCode()
    {
        return $this->catCode;
    }
    /**
     * Set catCode value
     * @param string $catCode
     * @return \RelatieApiV6\StructType\GetPrivacySubCatsRequest
     */
    public function setCatCode($catCode = null)
    {
        // validation for constraint: string
        if (!is_null($catCode) && !is_string($catCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($catCode, true), gettype($catCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($catCode) && mb_strlen($catCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($catCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($catCode) && mb_strlen($catCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($catCode)), __LINE__);
        }
        $this->catCode = $catCode;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\GetPrivacySubCatsRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
}
