<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getKlantKenmerkResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: error179: De kenmerkgroep is niet gevonden | error178: Er is geen kenmerkgroep opgegeven | error174: Het kenmerk is niet gevonden | error173: Er is geen kenmerk opgegeven | error19: Er is geen relatie opgegeven | error5: De relatie
 * is niet gevonden
 * @subpackage Structs
 * @date 20240419 package
 */
class GetKlantKenmerkResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The kenmerkNo
     * Meta information extracted from the WSDL
     * - documentation: Nummer die de koppeling tussen een relatie en een kenmerk uniek identificeert.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $kenmerkNo;
    /**
     * The relNoResult
     * Meta information extracted from the WSDL
     * - documentation: Het relatienummer die het kenmerk heeft. Kan afwijken van relNo als de relatie ontdubbelt is.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNoResult;
    /**
     * Constructor method for getKlantKenmerkResponse
     * @uses GetKlantKenmerkResponse::setRequestTag()
     * @uses GetKlantKenmerkResponse::setKenmerkNo()
     * @uses GetKlantKenmerkResponse::setRelNoResult()
     * @param string $requestTag
     * @param int $kenmerkNo
     * @param int $relNoResult
     */
    public function __construct($requestTag = null, $kenmerkNo = null, $relNoResult = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setKenmerkNo($kenmerkNo)
            ->setRelNoResult($relNoResult);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\GetKlantKenmerkResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get kenmerkNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getKenmerkNo()
    {
        return isset($this->kenmerkNo) ? $this->kenmerkNo : null;
    }
    /**
     * Set kenmerkNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $kenmerkNo
     * @return \RelatieApiV6\StructType\GetKlantKenmerkResponse
     */
    public function setKenmerkNo($kenmerkNo = null)
    {
        // validation for constraint: int
        if (!is_null($kenmerkNo) && !(is_int($kenmerkNo) || ctype_digit($kenmerkNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kenmerkNo, true), gettype($kenmerkNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($kenmerkNo) && mb_strlen(preg_replace('/(\D)/', '', $kenmerkNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($kenmerkNo, true), mb_strlen(preg_replace('/(\D)/', '', $kenmerkNo))), __LINE__);
        }
        if (is_null($kenmerkNo) || (is_array($kenmerkNo) && empty($kenmerkNo))) {
            unset($this->kenmerkNo);
        } else {
            $this->kenmerkNo = $kenmerkNo;
        }
        return $this;
    }
    /**
     * Get relNoResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNoResult()
    {
        return isset($this->relNoResult) ? $this->relNoResult : null;
    }
    /**
     * Set relNoResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNoResult
     * @return \RelatieApiV6\StructType\GetKlantKenmerkResponse
     */
    public function setRelNoResult($relNoResult = null)
    {
        // validation for constraint: int
        if (!is_null($relNoResult) && !(is_int($relNoResult) || ctype_digit($relNoResult))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNoResult, true), gettype($relNoResult)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNoResult) && mb_strlen(preg_replace('/(\D)/', '', $relNoResult)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNoResult, true), mb_strlen(preg_replace('/(\D)/', '', $relNoResult))), __LINE__);
        }
        if (is_null($relNoResult) || (is_array($relNoResult) && empty($relNoResult))) {
            unset($this->relNoResult);
        } else {
            $this->relNoResult = $relNoResult;
        }
        return $this;
    }
}
