<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Functietable StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met functie codes
 * @subpackage Structs
 * @date 20240419 package
 */
class Functietable extends AbstractStructBase
{
    /**
     * The functie
     * Meta information extracted from the WSDL
     * - documentation: Functies
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \RelatieApiV6\StructType\FunctieRec[]
     */
    public $functie;
    /**
     * Constructor method for Functietable
     * @uses Functietable::setFunctie()
     * @param \RelatieApiV6\StructType\FunctieRec[] $functie
     */
    public function __construct(array $functie = array())
    {
        $this
            ->setFunctie($functie);
    }
    /**
     * Get functie value
     * @return \RelatieApiV6\StructType\FunctieRec[]|null
     */
    public function getFunctie()
    {
        return $this->functie;
    }
    /**
     * This method is responsible for validating the values passed to the setFunctie method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFunctie method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFunctieForArrayConstraintsFromSetFunctie(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $functietableFunctieItem) {
            // validation for constraint: itemType
            if (!$functietableFunctieItem instanceof \RelatieApiV6\StructType\FunctieRec) {
                $invalidValues[] = is_object($functietableFunctieItem) ? get_class($functietableFunctieItem) : sprintf('%s(%s)', gettype($functietableFunctieItem), var_export($functietableFunctieItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The functie property can only contain items of type \RelatieApiV6\StructType\FunctieRec, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set functie value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV6\StructType\FunctieRec[] $functie
     * @return \RelatieApiV6\StructType\Functietable
     */
    public function setFunctie(array $functie = array())
    {
        // validation for constraint: array
        if ('' !== ($functieArrayErrorMessage = self::validateFunctieForArrayConstraintsFromSetFunctie($functie))) {
            throw new \InvalidArgumentException($functieArrayErrorMessage, __LINE__);
        }
        $this->functie = $functie;
        return $this;
    }
    /**
     * Add item to functie value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV6\StructType\FunctieRec $item
     * @return \RelatieApiV6\StructType\Functietable
     */
    public function addToFunctie(\RelatieApiV6\StructType\FunctieRec $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RelatieApiV6\StructType\FunctieRec) {
            throw new \InvalidArgumentException(sprintf('The functie property can only contain items of type \RelatieApiV6\StructType\FunctieRec, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->functie[] = $item;
        return $this;
    }
}
