<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Creditcard StructType
 * Meta information extracted from the WSDL
 * - documentation: Creditcard object.
 * @subpackage Structs
 * @date 20240419 package
 */
class Creditcard extends AbstractStructBase
{
    /**
     * The customerId
     * Meta information extracted from the WSDL
     * - documentation: CustomerId van de creditcard t.b.v. incasso op de creditcard bij de PSP
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $customerId;
    /**
     * The kaartHouder
     * Meta information extracted from the WSDL
     * - documentation: De naam van de kaarthouder van de creditcard
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $kaartHouder;
    /**
     * The kaartNummer
     * Meta information extracted from the WSDL
     * - documentation: Het nummer van de creditcard (uit veiligheidsoverwegingen alleen de laatste 4 cijfers)
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $kaartNummer;
    /**
     * The kaartSecurityType
     * Meta information extracted from the WSDL
     * - documentation: Security type van de creditcard (bijv. 3dsecure)
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $kaartSecurityType;
    /**
     * The kaartLabel
     * Meta information extracted from the WSDL
     * - documentation: Label van de creditcard (de naam van de creditcardmaatschappij)
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $kaartLabel;
    /**
     * The kaartExpiryDate
     * Meta information extracted from the WSDL
     * - documentation: De datum waarop de geldigheid van de creditcard verloopt
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $kaartExpiryDate;
    /**
     * Constructor method for Creditcard
     * @uses Creditcard::setCustomerId()
     * @uses Creditcard::setKaartHouder()
     * @uses Creditcard::setKaartNummer()
     * @uses Creditcard::setKaartSecurityType()
     * @uses Creditcard::setKaartLabel()
     * @uses Creditcard::setKaartExpiryDate()
     * @param string $customerId
     * @param string $kaartHouder
     * @param string $kaartNummer
     * @param string $kaartSecurityType
     * @param string $kaartLabel
     * @param string $kaartExpiryDate
     */
    public function __construct($customerId = null, $kaartHouder = null, $kaartNummer = null, $kaartSecurityType = null, $kaartLabel = null, $kaartExpiryDate = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setKaartHouder($kaartHouder)
            ->setKaartNummer($kaartNummer)
            ->setKaartSecurityType($kaartSecurityType)
            ->setKaartLabel($kaartLabel)
            ->setKaartExpiryDate($kaartExpiryDate);
    }
    /**
     * Get customerId value
     * @return string
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param string $customerId
     * @return \RelatieApiV6\StructType\Creditcard
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($customerId) && mb_strlen($customerId) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($customerId)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($customerId) && mb_strlen($customerId) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get kaartHouder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKaartHouder()
    {
        return isset($this->kaartHouder) ? $this->kaartHouder : null;
    }
    /**
     * Set kaartHouder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kaartHouder
     * @return \RelatieApiV6\StructType\Creditcard
     */
    public function setKaartHouder($kaartHouder = null)
    {
        // validation for constraint: string
        if (!is_null($kaartHouder) && !is_string($kaartHouder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kaartHouder, true), gettype($kaartHouder)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($kaartHouder) && mb_strlen($kaartHouder) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($kaartHouder)), __LINE__);
        }
        if (is_null($kaartHouder) || (is_array($kaartHouder) && empty($kaartHouder))) {
            unset($this->kaartHouder);
        } else {
            $this->kaartHouder = $kaartHouder;
        }
        return $this;
    }
    /**
     * Get kaartNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKaartNummer()
    {
        return isset($this->kaartNummer) ? $this->kaartNummer : null;
    }
    /**
     * Set kaartNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kaartNummer
     * @return \RelatieApiV6\StructType\Creditcard
     */
    public function setKaartNummer($kaartNummer = null)
    {
        // validation for constraint: string
        if (!is_null($kaartNummer) && !is_string($kaartNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kaartNummer, true), gettype($kaartNummer)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($kaartNummer) && mb_strlen($kaartNummer) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($kaartNummer)), __LINE__);
        }
        if (is_null($kaartNummer) || (is_array($kaartNummer) && empty($kaartNummer))) {
            unset($this->kaartNummer);
        } else {
            $this->kaartNummer = $kaartNummer;
        }
        return $this;
    }
    /**
     * Get kaartSecurityType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKaartSecurityType()
    {
        return isset($this->kaartSecurityType) ? $this->kaartSecurityType : null;
    }
    /**
     * Set kaartSecurityType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kaartSecurityType
     * @return \RelatieApiV6\StructType\Creditcard
     */
    public function setKaartSecurityType($kaartSecurityType = null)
    {
        // validation for constraint: string
        if (!is_null($kaartSecurityType) && !is_string($kaartSecurityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kaartSecurityType, true), gettype($kaartSecurityType)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($kaartSecurityType) && mb_strlen($kaartSecurityType) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($kaartSecurityType)), __LINE__);
        }
        if (is_null($kaartSecurityType) || (is_array($kaartSecurityType) && empty($kaartSecurityType))) {
            unset($this->kaartSecurityType);
        } else {
            $this->kaartSecurityType = $kaartSecurityType;
        }
        return $this;
    }
    /**
     * Get kaartLabel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKaartLabel()
    {
        return isset($this->kaartLabel) ? $this->kaartLabel : null;
    }
    /**
     * Set kaartLabel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kaartLabel
     * @return \RelatieApiV6\StructType\Creditcard
     */
    public function setKaartLabel($kaartLabel = null)
    {
        // validation for constraint: string
        if (!is_null($kaartLabel) && !is_string($kaartLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kaartLabel, true), gettype($kaartLabel)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($kaartLabel) && mb_strlen($kaartLabel) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($kaartLabel)), __LINE__);
        }
        if (is_null($kaartLabel) || (is_array($kaartLabel) && empty($kaartLabel))) {
            unset($this->kaartLabel);
        } else {
            $this->kaartLabel = $kaartLabel;
        }
        return $this;
    }
    /**
     * Get kaartExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKaartExpiryDate()
    {
        return isset($this->kaartExpiryDate) ? $this->kaartExpiryDate : null;
    }
    /**
     * Set kaartExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kaartExpiryDate
     * @return \RelatieApiV6\StructType\Creditcard
     */
    public function setKaartExpiryDate($kaartExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($kaartExpiryDate) && !is_string($kaartExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kaartExpiryDate, true), gettype($kaartExpiryDate)), __LINE__);
        }
        if (is_null($kaartExpiryDate) || (is_array($kaartExpiryDate) && empty($kaartExpiryDate))) {
            unset($this->kaartExpiryDate);
        } else {
            $this->kaartExpiryDate = $kaartExpiryDate;
        }
        return $this;
    }
}
