<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createVerbandResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: error170: Er bestaat al een relatieverband tussen relatie 1 en 2 met de opgegeven verbandcode | error135: Er is geen verband gevonden met de opgegeven verbandCode | error134: Er is geen verbandCode opgegeven | error37: Er is geen
 * relatienummer van relatie 2 opgegeven | error21: Er is geen relatie gevonden met het relatienummer van relatie 2 | error19: Er is geen relatienummer van relatie 1 opgegeven | error5: Er is geen relatie gevonden met het relatienummer van relatie 1
 * @subpackage Structs
 * @date 20240419 package
 */
class CreateVerbandResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The relNoRel1Result
     * Meta information extracted from the WSDL
     * - documentation: Het relatienummer van Relatie 1. (kan afwijken van relNoRel1 input in geval van ontdubbelde relatie).
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNoRel1Result;
    /**
     * The relNoRel2Result
     * Meta information extracted from the WSDL
     * - documentation: Het relatienummer van Relatie 2. (kan afwijken van relNoRel2 input in geval van ontdubbelde relatie).
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relNoRel2Result;
    /**
     * The verbandNo
     * Meta information extracted from the WSDL
     * - documentation: Identifier die het verband tussen Relatie 1 en Relatie 2 uniek identificeert.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $verbandNo;
    /**
     * Constructor method for createVerbandResponse
     * @uses CreateVerbandResponse::setRequestTag()
     * @uses CreateVerbandResponse::setRelNoRel1Result()
     * @uses CreateVerbandResponse::setRelNoRel2Result()
     * @uses CreateVerbandResponse::setVerbandNo()
     * @param string $requestTag
     * @param int $relNoRel1Result
     * @param int $relNoRel2Result
     * @param int $verbandNo
     */
    public function __construct($requestTag = null, $relNoRel1Result = null, $relNoRel2Result = null, $verbandNo = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setRelNoRel1Result($relNoRel1Result)
            ->setRelNoRel2Result($relNoRel2Result)
            ->setVerbandNo($verbandNo);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\CreateVerbandResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get relNoRel1Result value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNoRel1Result()
    {
        return isset($this->relNoRel1Result) ? $this->relNoRel1Result : null;
    }
    /**
     * Set relNoRel1Result value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNoRel1Result
     * @return \RelatieApiV6\StructType\CreateVerbandResponse
     */
    public function setRelNoRel1Result($relNoRel1Result = null)
    {
        // validation for constraint: int
        if (!is_null($relNoRel1Result) && !(is_int($relNoRel1Result) || ctype_digit($relNoRel1Result))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNoRel1Result, true), gettype($relNoRel1Result)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNoRel1Result) && mb_strlen(preg_replace('/(\D)/', '', $relNoRel1Result)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNoRel1Result, true), mb_strlen(preg_replace('/(\D)/', '', $relNoRel1Result))), __LINE__);
        }
        if (is_null($relNoRel1Result) || (is_array($relNoRel1Result) && empty($relNoRel1Result))) {
            unset($this->relNoRel1Result);
        } else {
            $this->relNoRel1Result = $relNoRel1Result;
        }
        return $this;
    }
    /**
     * Get relNoRel2Result value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelNoRel2Result()
    {
        return isset($this->relNoRel2Result) ? $this->relNoRel2Result : null;
    }
    /**
     * Set relNoRel2Result value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relNoRel2Result
     * @return \RelatieApiV6\StructType\CreateVerbandResponse
     */
    public function setRelNoRel2Result($relNoRel2Result = null)
    {
        // validation for constraint: int
        if (!is_null($relNoRel2Result) && !(is_int($relNoRel2Result) || ctype_digit($relNoRel2Result))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNoRel2Result, true), gettype($relNoRel2Result)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNoRel2Result) && mb_strlen(preg_replace('/(\D)/', '', $relNoRel2Result)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNoRel2Result, true), mb_strlen(preg_replace('/(\D)/', '', $relNoRel2Result))), __LINE__);
        }
        if (is_null($relNoRel2Result) || (is_array($relNoRel2Result) && empty($relNoRel2Result))) {
            unset($this->relNoRel2Result);
        } else {
            $this->relNoRel2Result = $relNoRel2Result;
        }
        return $this;
    }
    /**
     * Get verbandNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getVerbandNo()
    {
        return isset($this->verbandNo) ? $this->verbandNo : null;
    }
    /**
     * Set verbandNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $verbandNo
     * @return \RelatieApiV6\StructType\CreateVerbandResponse
     */
    public function setVerbandNo($verbandNo = null)
    {
        // validation for constraint: int
        if (!is_null($verbandNo) && !(is_int($verbandNo) || ctype_digit($verbandNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($verbandNo, true), gettype($verbandNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($verbandNo) && mb_strlen(preg_replace('/(\D)/', '', $verbandNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($verbandNo, true), mb_strlen(preg_replace('/(\D)/', '', $verbandNo))), __LINE__);
        }
        if (is_null($verbandNo) || (is_array($verbandNo) && empty($verbandNo))) {
            unset($this->verbandNo);
        } else {
            $this->verbandNo = $verbandNo;
        }
        return $this;
    }
}
