<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createAfdelingRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Aanmaken van een nieuwe afdeling bij een bedrijf
 * @subpackage Structs
 * @date 20240419 package
 */
class CreateAfdelingRequest extends AbstractStructBase
{
    /**
     * The relatienummerBedrijf
     * Meta information extracted from the WSDL
     * - documentation: Het relatienummer van het bedrijf waarbij de afdeling aangemaakt moet worden
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relatienummerBedrijf;
    /**
     * The afdeling
     * Meta information extracted from the WSDL
     * - documentation: De gegevens van de afdeling
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \RelatieApiV6\StructType\AfdelingRec
     */
    public $afdeling;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The forceerKandidaat
     * Meta information extracted from the WSDL
     * - documentation: False (default): Geef een foutmelding indien meerdere kandidaten voldoen aan de input.<br/>True: In geval van meerdere kandidaten wordt de beste match (o.b.v. klantspecifieke instelling) geretourneerd.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $forceerKandidaat;
    /**
     * Constructor method for createAfdelingRequest
     * @uses CreateAfdelingRequest::setRelatienummerBedrijf()
     * @uses CreateAfdelingRequest::setAfdeling()
     * @uses CreateAfdelingRequest::setRequestTag()
     * @uses CreateAfdelingRequest::setForceerKandidaat()
     * @param int $relatienummerBedrijf
     * @param \RelatieApiV6\StructType\AfdelingRec $afdeling
     * @param string $requestTag
     * @param bool $forceerKandidaat
     */
    public function __construct($relatienummerBedrijf = null, \RelatieApiV6\StructType\AfdelingRec $afdeling = null, $requestTag = null, $forceerKandidaat = null)
    {
        $this
            ->setRelatienummerBedrijf($relatienummerBedrijf)
            ->setAfdeling($afdeling)
            ->setRequestTag($requestTag)
            ->setForceerKandidaat($forceerKandidaat);
    }
    /**
     * Get relatienummerBedrijf value
     * @return int
     */
    public function getRelatienummerBedrijf()
    {
        return $this->relatienummerBedrijf;
    }
    /**
     * Set relatienummerBedrijf value
     * @param int $relatienummerBedrijf
     * @return \RelatieApiV6\StructType\CreateAfdelingRequest
     */
    public function setRelatienummerBedrijf($relatienummerBedrijf = null)
    {
        // validation for constraint: int
        if (!is_null($relatienummerBedrijf) && !(is_int($relatienummerBedrijf) || ctype_digit($relatienummerBedrijf))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatienummerBedrijf, true), gettype($relatienummerBedrijf)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatienummerBedrijf) && mb_strlen(preg_replace('/(\D)/', '', $relatienummerBedrijf)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatienummerBedrijf, true), mb_strlen(preg_replace('/(\D)/', '', $relatienummerBedrijf))), __LINE__);
        }
        $this->relatienummerBedrijf = $relatienummerBedrijf;
        return $this;
    }
    /**
     * Get afdeling value
     * @return \RelatieApiV6\StructType\AfdelingRec
     */
    public function getAfdeling()
    {
        return $this->afdeling;
    }
    /**
     * Set afdeling value
     * @param \RelatieApiV6\StructType\AfdelingRec $afdeling
     * @return \RelatieApiV6\StructType\CreateAfdelingRequest
     */
    public function setAfdeling(\RelatieApiV6\StructType\AfdelingRec $afdeling = null)
    {
        $this->afdeling = $afdeling;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\CreateAfdelingRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get forceerKandidaat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getForceerKandidaat()
    {
        return isset($this->forceerKandidaat) ? $this->forceerKandidaat : null;
    }
    /**
     * Set forceerKandidaat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $forceerKandidaat
     * @return \RelatieApiV6\StructType\CreateAfdelingRequest
     */
    public function setForceerKandidaat($forceerKandidaat = null)
    {
        // validation for constraint: boolean
        if (!is_null($forceerKandidaat) && !is_bool($forceerKandidaat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forceerKandidaat, true), gettype($forceerKandidaat)), __LINE__);
        }
        if (is_null($forceerKandidaat) || (is_array($forceerKandidaat) && empty($forceerKandidaat))) {
            unset($this->forceerKandidaat);
        } else {
            $this->forceerKandidaat = $forceerKandidaat;
        }
        return $this;
    }
}
