<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for checkTelefoonResponse StructType
 * @subpackage Structs
 * @date 20240419 package
 */
class CheckTelefoonResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The valide
     * Meta information extracted from the WSDL
     * - documentation: Geeft true als het telefoonnummer geldig is, anders false.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $valide;
    /**
     * The melding
     * Meta information extracted from the WSDL
     * - documentation: De melding als het telefoonnummer niet geldig is.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $melding;
    /**
     * Constructor method for checkTelefoonResponse
     * @uses CheckTelefoonResponse::setRequestTag()
     * @uses CheckTelefoonResponse::setValide()
     * @uses CheckTelefoonResponse::setMelding()
     * @param string $requestTag
     * @param bool $valide
     * @param string $melding
     */
    public function __construct($requestTag = null, $valide = null, $melding = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setValide($valide)
            ->setMelding($melding);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\CheckTelefoonResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get valide value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getValide()
    {
        return isset($this->valide) ? $this->valide : null;
    }
    /**
     * Set valide value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $valide
     * @return \RelatieApiV6\StructType\CheckTelefoonResponse
     */
    public function setValide($valide = null)
    {
        // validation for constraint: boolean
        if (!is_null($valide) && !is_bool($valide)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($valide, true), gettype($valide)), __LINE__);
        }
        if (is_null($valide) || (is_array($valide) && empty($valide))) {
            unset($this->valide);
        } else {
            $this->valide = $valide;
        }
        return $this;
    }
    /**
     * Get melding value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMelding()
    {
        return isset($this->melding) ? $this->melding : null;
    }
    /**
     * Set melding value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $melding
     * @return \RelatieApiV6\StructType\CheckTelefoonResponse
     */
    public function setMelding($melding = null)
    {
        // validation for constraint: string
        if (!is_null($melding) && !is_string($melding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($melding, true), gettype($melding)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($melding) && mb_strlen($melding) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($melding)), __LINE__);
        }
        if (is_null($melding) || (is_array($melding) && empty($melding))) {
            unset($this->melding);
        } else {
            $this->melding = $melding;
        }
        return $this;
    }
}
