<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for checkTelefoonRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Checkt of een telefoon nummer voldoet aan de eisen die Zeno stelt. <br/>Een leeg telefoonnummer is niet geldig. <br/> <br/>Als het land Nederland is of geen land is meegegeven: <br/>- Haal alle niet numerieke karakters uit het
 * telefoonnummer. <br/>- Haal eventueel +31 eraf als het aan het begin staat. (en + aan het begin wordt overgeslagen in de vorige stap) en zet er dan nog een 0 voor om een compleet netnummer te krijgen. <br/>- Als het nummer op dit moment niet uit 9 of
 * 10 cijfers bestaat is het ongeldig. <br/>- Als het nummer uit 9 cijfers bestaat, maar het eerste cijfer is ongelijk aan 0 wordt er nog een voorloopnul voor gezet. Anders is het ongeldig. <br/>- Er wordt gecontroleerd of het nummer begin met een van
 * de netnummers uit de Zeno netnummer tabel, anders is het ongeldig. <br/> <br/>Anders als het buitenland is: <br/>- Er wordt gecontroleerd of het nummer uit de tekens 0 t/m 9 bestaat of een (, ), - of een + aan het begin, als dat niet zo is is het
 * ongeldig.
 * @subpackage Structs
 * @date 20240419 package
 */
class CheckTelefoonRequest extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The telefoonNummer
     * Meta information extracted from the WSDL
     * - documentation: Het telefoonnummer.
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $telefoonNummer;
    /**
     * The landCode
     * Meta information extracted from the WSDL
     * - documentation: Land waarvoor het telefoonnummer wordt gecontroleerd.
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $landCode;
    /**
     * Constructor method for checkTelefoonRequest
     * @uses CheckTelefoonRequest::setRequestTag()
     * @uses CheckTelefoonRequest::setTelefoonNummer()
     * @uses CheckTelefoonRequest::setLandCode()
     * @param string $requestTag
     * @param string $telefoonNummer
     * @param string $landCode
     */
    public function __construct($requestTag = null, $telefoonNummer = null, $landCode = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setTelefoonNummer($telefoonNummer)
            ->setLandCode($landCode);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\CheckTelefoonRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get telefoonNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTelefoonNummer()
    {
        return isset($this->telefoonNummer) ? $this->telefoonNummer : null;
    }
    /**
     * Set telefoonNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $telefoonNummer
     * @return \RelatieApiV6\StructType\CheckTelefoonRequest
     */
    public function setTelefoonNummer($telefoonNummer = null)
    {
        // validation for constraint: string
        if (!is_null($telefoonNummer) && !is_string($telefoonNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefoonNummer, true), gettype($telefoonNummer)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($telefoonNummer) && mb_strlen($telefoonNummer) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($telefoonNummer)), __LINE__);
        }
        if (is_null($telefoonNummer) || (is_array($telefoonNummer) && empty($telefoonNummer))) {
            unset($this->telefoonNummer);
        } else {
            $this->telefoonNummer = $telefoonNummer;
        }
        return $this;
    }
    /**
     * Get landCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLandCode()
    {
        return isset($this->landCode) ? $this->landCode : null;
    }
    /**
     * Set landCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $landCode
     * @return \RelatieApiV6\StructType\CheckTelefoonRequest
     */
    public function setLandCode($landCode = null)
    {
        // validation for constraint: string
        if (!is_null($landCode) && !is_string($landCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($landCode, true), gettype($landCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($landCode) && mb_strlen($landCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($landCode)), __LINE__);
        }
        if (is_null($landCode) || (is_array($landCode) && empty($landCode))) {
            unset($this->landCode);
        } else {
            $this->landCode = $landCode;
        }
        return $this;
    }
}
