<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for checkEmailRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Controleren van gebruik van een e-mail adres. Controleer eerst of de relatie kan worden bepaald aan de hand van het email adres van de relatie, als er op basis daarvan meerdere worden gevonden, wordt bepaald of op basis van ook de
 * username toch een unieke relatie kan worden gevonden.
 * @subpackage Structs
 * @date 20240419 package
 */
class CheckEmailRequest extends AbstractStructBase
{
    /**
     * The email
     * Meta information extracted from the WSDL
     * - documentation: Het te controleren e-mail adres
     * - base: xsd:string
     * - maxLength: 250
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $email;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * Constructor method for checkEmailRequest
     * @uses CheckEmailRequest::setEmail()
     * @uses CheckEmailRequest::setRequestTag()
     * @param string $email
     * @param string $requestTag
     */
    public function __construct($email = null, $requestTag = null)
    {
        $this
            ->setEmail($email)
            ->setRequestTag($requestTag);
    }
    /**
     * Get email value
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \RelatieApiV6\StructType\CheckEmailRequest
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (!is_null($email) && mb_strlen($email) > 250) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen($email)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($email) && mb_strlen($email) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\CheckEmailRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
}
