<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BetaalRec StructType
 * Meta information extracted from the WSDL
 * - documentation: Betaalwijze gegevens.
 * @subpackage Structs
 * @date 20240419 package
 */
class BetaalRec extends AbstractStructBase
{
    /**
     * The betaalwijze
     * Meta information extracted from the WSDL
     * - documentation: Betaalwijze [0,1,3,4,6,7] (0=Factuur, 1= Eenmalige Automatisch incasso, 3= Eenmalige iDeal, 4= Factuur per mail, 6=Paypal, 7= Creditcard)
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $betaalwijze;
    /**
     * The bankrekeningnummer
     * Meta information extracted from the WSDL
     * - documentation: Bankrekeningnummer (indien betaalwijze = Automatische incasso en geen gebruik SEPA, dan verplicht)
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $bankrekeningnummer;
    /**
     * The ibannummer
     * Meta information extracted from the WSDL
     * - documentation: Iban nummer (indien betaalwijze = Automatische incasso en gebruik SEPA, dan verplicht)
     * - base: xsd:string
     * - maxLength: 34
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ibannummer;
    /**
     * The bicCode
     * Meta information extracted from the WSDL
     * - documentation: Bic code ((indien betaalwijze = Automatische incasso en gebruik SEPA, niet verplicht)
     * - base: xsd:string
     * - maxLength: 11
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $bicCode;
    /**
     * The creditcard
     * Meta information extracted from the WSDL
     * - documentation: Creditcard gegevens (indien betaalwijze = Creditcard, dan verplicht)
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\Creditcard
     */
    public $creditcard;
    /**
     * Constructor method for BetaalRec
     * @uses BetaalRec::setBetaalwijze()
     * @uses BetaalRec::setBankrekeningnummer()
     * @uses BetaalRec::setIbannummer()
     * @uses BetaalRec::setBicCode()
     * @uses BetaalRec::setCreditcard()
     * @param float $betaalwijze
     * @param string $bankrekeningnummer
     * @param string $ibannummer
     * @param string $bicCode
     * @param \RelatieApiV6\StructType\Creditcard $creditcard
     */
    public function __construct($betaalwijze = null, $bankrekeningnummer = null, $ibannummer = null, $bicCode = null, \RelatieApiV6\StructType\Creditcard $creditcard = null)
    {
        $this
            ->setBetaalwijze($betaalwijze)
            ->setBankrekeningnummer($bankrekeningnummer)
            ->setIbannummer($ibannummer)
            ->setBicCode($bicCode)
            ->setCreditcard($creditcard);
    }
    /**
     * Get betaalwijze value
     * @return float
     */
    public function getBetaalwijze()
    {
        return $this->betaalwijze;
    }
    /**
     * Set betaalwijze value
     * @param float $betaalwijze
     * @return \RelatieApiV6\StructType\BetaalRec
     */
    public function setBetaalwijze($betaalwijze = null)
    {
        // validation for constraint: float
        if (!is_null($betaalwijze) && !(is_float($betaalwijze) || is_numeric($betaalwijze))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($betaalwijze, true), gettype($betaalwijze)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($betaalwijze) && mb_strlen(preg_replace('/(\D)/', '', $betaalwijze)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($betaalwijze, true), mb_strlen(preg_replace('/(\D)/', '', $betaalwijze))), __LINE__);
        }
        $this->betaalwijze = $betaalwijze;
        return $this;
    }
    /**
     * Get bankrekeningnummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankrekeningnummer()
    {
        return isset($this->bankrekeningnummer) ? $this->bankrekeningnummer : null;
    }
    /**
     * Set bankrekeningnummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankrekeningnummer
     * @return \RelatieApiV6\StructType\BetaalRec
     */
    public function setBankrekeningnummer($bankrekeningnummer = null)
    {
        // validation for constraint: string
        if (!is_null($bankrekeningnummer) && !is_string($bankrekeningnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankrekeningnummer, true), gettype($bankrekeningnummer)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($bankrekeningnummer) && mb_strlen($bankrekeningnummer) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($bankrekeningnummer)), __LINE__);
        }
        if (is_null($bankrekeningnummer) || (is_array($bankrekeningnummer) && empty($bankrekeningnummer))) {
            unset($this->bankrekeningnummer);
        } else {
            $this->bankrekeningnummer = $bankrekeningnummer;
        }
        return $this;
    }
    /**
     * Get ibannummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIbannummer()
    {
        return isset($this->ibannummer) ? $this->ibannummer : null;
    }
    /**
     * Set ibannummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ibannummer
     * @return \RelatieApiV6\StructType\BetaalRec
     */
    public function setIbannummer($ibannummer = null)
    {
        // validation for constraint: string
        if (!is_null($ibannummer) && !is_string($ibannummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ibannummer, true), gettype($ibannummer)), __LINE__);
        }
        // validation for constraint: maxLength(34)
        if (!is_null($ibannummer) && mb_strlen($ibannummer) > 34) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 34', mb_strlen($ibannummer)), __LINE__);
        }
        if (is_null($ibannummer) || (is_array($ibannummer) && empty($ibannummer))) {
            unset($this->ibannummer);
        } else {
            $this->ibannummer = $ibannummer;
        }
        return $this;
    }
    /**
     * Get bicCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBicCode()
    {
        return isset($this->bicCode) ? $this->bicCode : null;
    }
    /**
     * Set bicCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bicCode
     * @return \RelatieApiV6\StructType\BetaalRec
     */
    public function setBicCode($bicCode = null)
    {
        // validation for constraint: string
        if (!is_null($bicCode) && !is_string($bicCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bicCode, true), gettype($bicCode)), __LINE__);
        }
        // validation for constraint: maxLength(11)
        if (!is_null($bicCode) && mb_strlen($bicCode) > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 11', mb_strlen($bicCode)), __LINE__);
        }
        if (is_null($bicCode) || (is_array($bicCode) && empty($bicCode))) {
            unset($this->bicCode);
        } else {
            $this->bicCode = $bicCode;
        }
        return $this;
    }
    /**
     * Get creditcard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\Creditcard|null
     */
    public function getCreditcard()
    {
        return isset($this->creditcard) ? $this->creditcard : null;
    }
    /**
     * Set creditcard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\Creditcard $creditcard
     * @return \RelatieApiV6\StructType\BetaalRec
     */
    public function setCreditcard(\RelatieApiV6\StructType\Creditcard $creditcard = null)
    {
        if (is_null($creditcard) || (is_array($creditcard) && empty($creditcard))) {
            unset($this->creditcard);
        } else {
            $this->creditcard = $creditcard;
        }
        return $this;
    }
}
