<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BedrijfinfoRec StructType
 * Meta information extracted from the WSDL
 * - documentation: Bedrijfsgegevens
 * @subpackage Structs
 * @date 20240419 package
 */
class BedrijfinfoRec extends AbstractStructBase
{
    /**
     * The bedrijf
     * Meta information extracted from the WSDL
     * - documentation: De bedrijfsgegevens
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\BedrijfRec
     */
    public $bedrijf;
    /**
     * The contactpersonen
     * Meta information extracted from the WSDL
     * - documentation: Een lijst met de contactpersonen binnen het bedrijf
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\Contactpersoontable
     */
    public $contactpersonen;
    /**
     * The afdelingen
     * Meta information extracted from the WSDL
     * - documentation: Een lijst met de afdelingen binnen het bedrijf
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\Afdelingtable
     */
    public $afdelingen;
    /**
     * The leververbod
     * Meta information extracted from the WSDL
     * - documentation: De relatie heeft een leververbod
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $leververbod;
    /**
     * The relatienummerDebiteur
     * Meta information extracted from the WSDL
     * - documentation: Het relatienummer van de vaste debiteur van het bedrijf
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relatienummerDebiteur;
    /**
     * The functies
     * Meta information extracted from the WSDL
     * - documentation: De bij het bedrijf aanwezige functies
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\RelatieFunctietable
     */
    public $functies;
    /**
     * The biccodes
     * Meta information extracted from the WSDL
     * - documentation: De bij het bedrijf aanwezige biccodes
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\RelatieBiccodetable
     */
    public $biccodes;
    /**
     * Constructor method for BedrijfinfoRec
     * @uses BedrijfinfoRec::setBedrijf()
     * @uses BedrijfinfoRec::setContactpersonen()
     * @uses BedrijfinfoRec::setAfdelingen()
     * @uses BedrijfinfoRec::setLeververbod()
     * @uses BedrijfinfoRec::setRelatienummerDebiteur()
     * @uses BedrijfinfoRec::setFuncties()
     * @uses BedrijfinfoRec::setBiccodes()
     * @param \RelatieApiV6\StructType\BedrijfRec $bedrijf
     * @param \RelatieApiV6\StructType\Contactpersoontable $contactpersonen
     * @param \RelatieApiV6\StructType\Afdelingtable $afdelingen
     * @param bool $leververbod
     * @param int $relatienummerDebiteur
     * @param \RelatieApiV6\StructType\RelatieFunctietable $functies
     * @param \RelatieApiV6\StructType\RelatieBiccodetable $biccodes
     */
    public function __construct(\RelatieApiV6\StructType\BedrijfRec $bedrijf = null, \RelatieApiV6\StructType\Contactpersoontable $contactpersonen = null, \RelatieApiV6\StructType\Afdelingtable $afdelingen = null, $leververbod = null, $relatienummerDebiteur = null, \RelatieApiV6\StructType\RelatieFunctietable $functies = null, \RelatieApiV6\StructType\RelatieBiccodetable $biccodes = null)
    {
        $this
            ->setBedrijf($bedrijf)
            ->setContactpersonen($contactpersonen)
            ->setAfdelingen($afdelingen)
            ->setLeververbod($leververbod)
            ->setRelatienummerDebiteur($relatienummerDebiteur)
            ->setFuncties($functies)
            ->setBiccodes($biccodes);
    }
    /**
     * Get bedrijf value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\BedrijfRec|null
     */
    public function getBedrijf()
    {
        return isset($this->bedrijf) ? $this->bedrijf : null;
    }
    /**
     * Set bedrijf value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\BedrijfRec $bedrijf
     * @return \RelatieApiV6\StructType\BedrijfinfoRec
     */
    public function setBedrijf(\RelatieApiV6\StructType\BedrijfRec $bedrijf = null)
    {
        if (is_null($bedrijf) || (is_array($bedrijf) && empty($bedrijf))) {
            unset($this->bedrijf);
        } else {
            $this->bedrijf = $bedrijf;
        }
        return $this;
    }
    /**
     * Get contactpersonen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\Contactpersoontable|null
     */
    public function getContactpersonen()
    {
        return isset($this->contactpersonen) ? $this->contactpersonen : null;
    }
    /**
     * Set contactpersonen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\Contactpersoontable $contactpersonen
     * @return \RelatieApiV6\StructType\BedrijfinfoRec
     */
    public function setContactpersonen(\RelatieApiV6\StructType\Contactpersoontable $contactpersonen = null)
    {
        if (is_null($contactpersonen) || (is_array($contactpersonen) && empty($contactpersonen))) {
            unset($this->contactpersonen);
        } else {
            $this->contactpersonen = $contactpersonen;
        }
        return $this;
    }
    /**
     * Get afdelingen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\Afdelingtable|null
     */
    public function getAfdelingen()
    {
        return isset($this->afdelingen) ? $this->afdelingen : null;
    }
    /**
     * Set afdelingen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\Afdelingtable $afdelingen
     * @return \RelatieApiV6\StructType\BedrijfinfoRec
     */
    public function setAfdelingen(\RelatieApiV6\StructType\Afdelingtable $afdelingen = null)
    {
        if (is_null($afdelingen) || (is_array($afdelingen) && empty($afdelingen))) {
            unset($this->afdelingen);
        } else {
            $this->afdelingen = $afdelingen;
        }
        return $this;
    }
    /**
     * Get leververbod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getLeververbod()
    {
        return isset($this->leververbod) ? $this->leververbod : null;
    }
    /**
     * Set leververbod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $leververbod
     * @return \RelatieApiV6\StructType\BedrijfinfoRec
     */
    public function setLeververbod($leververbod = null)
    {
        // validation for constraint: boolean
        if (!is_null($leververbod) && !is_bool($leververbod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($leververbod, true), gettype($leververbod)), __LINE__);
        }
        if (is_null($leververbod) || (is_array($leververbod) && empty($leververbod))) {
            unset($this->leververbod);
        } else {
            $this->leververbod = $leververbod;
        }
        return $this;
    }
    /**
     * Get relatienummerDebiteur value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelatienummerDebiteur()
    {
        return isset($this->relatienummerDebiteur) ? $this->relatienummerDebiteur : null;
    }
    /**
     * Set relatienummerDebiteur value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relatienummerDebiteur
     * @return \RelatieApiV6\StructType\BedrijfinfoRec
     */
    public function setRelatienummerDebiteur($relatienummerDebiteur = null)
    {
        // validation for constraint: int
        if (!is_null($relatienummerDebiteur) && !(is_int($relatienummerDebiteur) || ctype_digit($relatienummerDebiteur))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatienummerDebiteur, true), gettype($relatienummerDebiteur)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatienummerDebiteur) && mb_strlen(preg_replace('/(\D)/', '', $relatienummerDebiteur)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatienummerDebiteur, true), mb_strlen(preg_replace('/(\D)/', '', $relatienummerDebiteur))), __LINE__);
        }
        if (is_null($relatienummerDebiteur) || (is_array($relatienummerDebiteur) && empty($relatienummerDebiteur))) {
            unset($this->relatienummerDebiteur);
        } else {
            $this->relatienummerDebiteur = $relatienummerDebiteur;
        }
        return $this;
    }
    /**
     * Get functies value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\RelatieFunctietable|null
     */
    public function getFuncties()
    {
        return isset($this->functies) ? $this->functies : null;
    }
    /**
     * Set functies value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\RelatieFunctietable $functies
     * @return \RelatieApiV6\StructType\BedrijfinfoRec
     */
    public function setFuncties(\RelatieApiV6\StructType\RelatieFunctietable $functies = null)
    {
        if (is_null($functies) || (is_array($functies) && empty($functies))) {
            unset($this->functies);
        } else {
            $this->functies = $functies;
        }
        return $this;
    }
    /**
     * Get biccodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\RelatieBiccodetable|null
     */
    public function getBiccodes()
    {
        return isset($this->biccodes) ? $this->biccodes : null;
    }
    /**
     * Set biccodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\RelatieBiccodetable $biccodes
     * @return \RelatieApiV6\StructType\BedrijfinfoRec
     */
    public function setBiccodes(\RelatieApiV6\StructType\RelatieBiccodetable $biccodes = null)
    {
        if (is_null($biccodes) || (is_array($biccodes) && empty($biccodes))) {
            unset($this->biccodes);
        } else {
            $this->biccodes = $biccodes;
        }
        return $this;
    }
}
