<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addFunctieResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: error32: De opgegeven functiecode is al gekoppeld aan de relatie | error30: De opgegeven functiecode is niet gevonden | error29: Er is geen functiecode opgegeven | error16: Op basis van het opgegeven nummer is geen relatie gevonden |
 * error15: Er is geen relatienummer opgegeven
 * @subpackage Structs
 * @date 20240419 package
 */
class AddFunctieResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The relatieFunctieSleutel
     * Meta information extracted from the WSDL
     * - documentation: De unieke sleutel van de koppeling van de functie aan de relatie
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relatieFunctieSleutel;
    /**
     * The relatieSleutelGebruikt
     * Meta information extracted from the WSDL
     * - documentation: Het gebruikte relatienummer voor de koppeling
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relatieSleutelGebruikt;
    /**
     * Constructor method for addFunctieResponse
     * @uses AddFunctieResponse::setRequestTag()
     * @uses AddFunctieResponse::setRelatieFunctieSleutel()
     * @uses AddFunctieResponse::setRelatieSleutelGebruikt()
     * @param string $requestTag
     * @param int $relatieFunctieSleutel
     * @param int $relatieSleutelGebruikt
     */
    public function __construct($requestTag = null, $relatieFunctieSleutel = null, $relatieSleutelGebruikt = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setRelatieFunctieSleutel($relatieFunctieSleutel)
            ->setRelatieSleutelGebruikt($relatieSleutelGebruikt);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\AddFunctieResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get relatieFunctieSleutel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelatieFunctieSleutel()
    {
        return isset($this->relatieFunctieSleutel) ? $this->relatieFunctieSleutel : null;
    }
    /**
     * Set relatieFunctieSleutel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relatieFunctieSleutel
     * @return \RelatieApiV6\StructType\AddFunctieResponse
     */
    public function setRelatieFunctieSleutel($relatieFunctieSleutel = null)
    {
        // validation for constraint: int
        if (!is_null($relatieFunctieSleutel) && !(is_int($relatieFunctieSleutel) || ctype_digit($relatieFunctieSleutel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatieFunctieSleutel, true), gettype($relatieFunctieSleutel)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatieFunctieSleutel) && mb_strlen(preg_replace('/(\D)/', '', $relatieFunctieSleutel)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatieFunctieSleutel, true), mb_strlen(preg_replace('/(\D)/', '', $relatieFunctieSleutel))), __LINE__);
        }
        if (is_null($relatieFunctieSleutel) || (is_array($relatieFunctieSleutel) && empty($relatieFunctieSleutel))) {
            unset($this->relatieFunctieSleutel);
        } else {
            $this->relatieFunctieSleutel = $relatieFunctieSleutel;
        }
        return $this;
    }
    /**
     * Get relatieSleutelGebruikt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelatieSleutelGebruikt()
    {
        return isset($this->relatieSleutelGebruikt) ? $this->relatieSleutelGebruikt : null;
    }
    /**
     * Set relatieSleutelGebruikt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relatieSleutelGebruikt
     * @return \RelatieApiV6\StructType\AddFunctieResponse
     */
    public function setRelatieSleutelGebruikt($relatieSleutelGebruikt = null)
    {
        // validation for constraint: int
        if (!is_null($relatieSleutelGebruikt) && !(is_int($relatieSleutelGebruikt) || ctype_digit($relatieSleutelGebruikt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatieSleutelGebruikt, true), gettype($relatieSleutelGebruikt)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatieSleutelGebruikt) && mb_strlen(preg_replace('/(\D)/', '', $relatieSleutelGebruikt)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatieSleutelGebruikt, true), mb_strlen(preg_replace('/(\D)/', '', $relatieSleutelGebruikt))), __LINE__);
        }
        if (is_null($relatieSleutelGebruikt) || (is_array($relatieSleutelGebruikt) && empty($relatieSleutelGebruikt))) {
            unset($this->relatieSleutelGebruikt);
        } else {
            $this->relatieSleutelGebruikt = $relatieSleutelGebruikt;
        }
        return $this;
    }
}
