<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addBicResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: error31: De opgegeven bic-code is al gekoppeld aan de relatie | error26: De opgegeven bic-code is niet gevonden | error25: Er is geen Bic-code opgegeven | error16: Op basis van het opgegeven nummer is geen relatie gevonden | error15:
 * Er is geen relatienummer opgegeven
 * @subpackage Structs
 * @date 20240419 package
 */
class AddBicResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The relatieBicNummer
     * Meta information extracted from the WSDL
     * - documentation: Het unieke nummer voor de aangemaakte koppeling
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relatieBicNummer;
    /**
     * The relatieNummerGebruikt
     * Meta information extracted from the WSDL
     * - documentation: Het gebruikte relatienummer voor de koppeling
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relatieNummerGebruikt;
    /**
     * Constructor method for addBicResponse
     * @uses AddBicResponse::setRequestTag()
     * @uses AddBicResponse::setRelatieBicNummer()
     * @uses AddBicResponse::setRelatieNummerGebruikt()
     * @param string $requestTag
     * @param int $relatieBicNummer
     * @param int $relatieNummerGebruikt
     */
    public function __construct($requestTag = null, $relatieBicNummer = null, $relatieNummerGebruikt = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setRelatieBicNummer($relatieBicNummer)
            ->setRelatieNummerGebruikt($relatieNummerGebruikt);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\AddBicResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get relatieBicNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelatieBicNummer()
    {
        return isset($this->relatieBicNummer) ? $this->relatieBicNummer : null;
    }
    /**
     * Set relatieBicNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relatieBicNummer
     * @return \RelatieApiV6\StructType\AddBicResponse
     */
    public function setRelatieBicNummer($relatieBicNummer = null)
    {
        // validation for constraint: int
        if (!is_null($relatieBicNummer) && !(is_int($relatieBicNummer) || ctype_digit($relatieBicNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatieBicNummer, true), gettype($relatieBicNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatieBicNummer) && mb_strlen(preg_replace('/(\D)/', '', $relatieBicNummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatieBicNummer, true), mb_strlen(preg_replace('/(\D)/', '', $relatieBicNummer))), __LINE__);
        }
        if (is_null($relatieBicNummer) || (is_array($relatieBicNummer) && empty($relatieBicNummer))) {
            unset($this->relatieBicNummer);
        } else {
            $this->relatieBicNummer = $relatieBicNummer;
        }
        return $this;
    }
    /**
     * Get relatieNummerGebruikt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelatieNummerGebruikt()
    {
        return isset($this->relatieNummerGebruikt) ? $this->relatieNummerGebruikt : null;
    }
    /**
     * Set relatieNummerGebruikt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relatieNummerGebruikt
     * @return \RelatieApiV6\StructType\AddBicResponse
     */
    public function setRelatieNummerGebruikt($relatieNummerGebruikt = null)
    {
        // validation for constraint: int
        if (!is_null($relatieNummerGebruikt) && !(is_int($relatieNummerGebruikt) || ctype_digit($relatieNummerGebruikt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatieNummerGebruikt, true), gettype($relatieNummerGebruikt)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatieNummerGebruikt) && mb_strlen(preg_replace('/(\D)/', '', $relatieNummerGebruikt)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatieNummerGebruikt, true), mb_strlen(preg_replace('/(\D)/', '', $relatieNummerGebruikt))), __LINE__);
        }
        if (is_null($relatieNummerGebruikt) || (is_array($relatieNummerGebruikt) && empty($relatieNummerGebruikt))) {
            unset($this->relatieNummerGebruikt);
        } else {
            $this->relatieNummerGebruikt = $relatieNummerGebruikt;
        }
        return $this;
    }
}
