<?php

namespace RelatieApiV6\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Search ServiceType
 * @subpackage Services
 * @date 20240419 package
 */
class Search extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named searchEmail
     * Meta information extracted from the WSDL
     * - documentation: Zoekt relatienummers bij het opgegeven e-mail adres
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\SearchEmailRequest $request_parameters
     * @return \RelatieApiV6\StructType\SearchEmailResponse|bool
     */
    public function searchEmail(\RelatieApiV6\StructType\SearchEmailRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->searchEmail($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchBedrijf
     * Meta information extracted from the WSDL
     * - documentation: Zoeken naar bedrijven op basis van postcode + huisnummer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\SearchBedrijfRequest $request_parameters
     * @return \RelatieApiV6\StructType\SearchBedrijfResponse|bool
     */
    public function searchBedrijf(\RelatieApiV6\StructType\SearchBedrijfRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->searchBedrijf($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchNaam
     * Meta information extracted from the WSDL
     * - documentation: Zoeken naar relaties op basis van de naamerror15: Er is geen zoekvoorwaarde opgegevenerror1104: Ongeldige zoekMethodeerror1105: Ongeldige relatieType
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\SearchNaamRequest $request_parameters
     * @return \RelatieApiV6\StructType\SearchNaamResponse|bool
     */
    public function searchNaam(\RelatieApiV6\StructType\SearchNaamRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->searchNaam($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchPersoon
     * Meta information extracted from the WSDL
     * - documentation: Zoeken naar personen op basis van postcode + huisnummer of e-mail 1 of e-mail 2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\SearchPersoonRequest $request_parameters
     * @return \RelatieApiV6\StructType\SearchPersoonResponse|bool
     */
    public function searchPersoon(\RelatieApiV6\StructType\SearchPersoonRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->searchPersoon($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchBedrijfInclCont
     * Meta information extracted from the WSDL
     * - documentation: Zoeken naar relaties op basis van postcode + huisnummer of e-mail 1, e-mail 2, e-mail 3 of e-mail 4 Kan alleen gebruikt worden indien systeem-constante "Invoer van bedrijven op de relatiekaart inclusief contactpersoon" geactiveerd
     * is.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\SearchBedrijfInclContRequest $request_parameters
     * @return \RelatieApiV6\StructType\SearchBedrijfInclContResponse|bool
     */
    public function searchBedrijfInclCont(\RelatieApiV6\StructType\SearchBedrijfInclContRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->searchBedrijfInclCont($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchUsername
     * Meta information extracted from the WSDL
     * - documentation: Geeft het relatienummer terug van de relatie behorende bij de usernameerror1: Op basis van de username is geen unieke relatie gevonden.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\SearchUsernameRequest $request_parameters
     * @return \RelatieApiV6\StructType\SearchUsernameResponse|bool
     */
    public function searchUsername(\RelatieApiV6\StructType\SearchUsernameRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->searchUsername($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchSmartcode
     * Meta information extracted from the WSDL
     * - documentation: Geeft het relatienummer terug van de relatie behorende bij de smartcodeerror1: Op basis van de smartcode is geen relatie gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\SearchSmartcodeRequest $request_parameters
     * @return \RelatieApiV6\StructType\SearchSmartcodeResponse|bool
     */
    public function searchSmartcode(\RelatieApiV6\StructType\SearchSmartcodeRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->searchSmartcode($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named searchExternNummer
     * Meta information extracted from the WSDL
     * - documentation: Geeft het relatienummer terug van de relatie behorende bij het externe nummererror1: Op basis van het externe nummer is geen relatie gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\SearchExternNummerRequest $request_parameters
     * @return \RelatieApiV6\StructType\SearchExternNummerResponse|bool
     */
    public function searchExternNummer(\RelatieApiV6\StructType\SearchExternNummerRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->searchExternNummer($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \RelatieApiV6\StructType\SearchBedrijfInclContResponse|\RelatieApiV6\StructType\SearchBedrijfResponse|\RelatieApiV6\StructType\SearchEmailResponse|\RelatieApiV6\StructType\SearchExternNummerResponse|\RelatieApiV6\StructType\SearchNaamResponse|\RelatieApiV6\StructType\SearchPersoonResponse|\RelatieApiV6\StructType\SearchSmartcodeResponse|\RelatieApiV6\StructType\SearchUsernameResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
