<?php

namespace RelatieApiV6\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 * @date 20240419 package
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getFuncties
     * Meta information extracted from the WSDL
     * - documentation: Ophalen van beschikbare functies die aan een relatie te koppelen zijnerror42: Er zijn geen functies gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\GetFunctiesRequest $request_parameters
     * @return \RelatieApiV6\StructType\GetFunctiesResponse|bool
     */
    public function getFuncties(\RelatieApiV6\StructType\GetFunctiesRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getFuncties($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBiccodes
     * Meta information extracted from the WSDL
     * - documentation: Ophalen van beschikbare Bic-codes die aan een relatie te koppelen zijnerror43: Er zijn geen Bic-codes gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\GetBiccodesRequest $request_parameters
     * @return \RelatieApiV6\StructType\GetBiccodesResponse|bool
     */
    public function getBiccodes(\RelatieApiV6\StructType\GetBiccodesRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBiccodes($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTitulatuurcodes
     * Meta information extracted from the WSDL
     * - documentation: Ophalen van beschikbare Bic-codes die aan een relatie te koppelen zijnerror44: Er zijn geen Titulatuur-codes gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\GetTitulatuurcodesRequest $request_parameters
     * @return \RelatieApiV6\StructType\GetTitulatuurcodesResponse|bool
     */
    public function getTitulatuurcodes(\RelatieApiV6\StructType\GetTitulatuurcodesRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getTitulatuurcodes($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLandcodes
     * Meta information extracted from the WSDL
     * - documentation: Ophalen van beschikbare landcodes die bij een relatie als land opgenomen kunnen wordenerror45: Er zijn geen Landcodes gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\GetLandcodesRequest $request_parameters
     * @return \RelatieApiV6\StructType\GetLandcodesResponse|bool
     */
    public function getLandcodes(\RelatieApiV6\StructType\GetLandcodesRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getLandcodes($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTaalcodes
     * Meta information extracted from the WSDL
     * - documentation: Ophalen van beschikbare taalcodes die bij een relatie als taal opgenomen kunnen wordenerror105: Er zijn geen Taalcodes gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\GetTaalcodesRequest $request_parameters
     * @return \RelatieApiV6\StructType\GetTaalcodesResponse|bool
     */
    public function getTaalcodes(\RelatieApiV6\StructType\GetTaalcodesRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getTaalcodes($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getProvinciecodes
     * Meta information extracted from the WSDL
     * - documentation: Ophalen van beschikbare provinciecodes die bij een relatie als provincie opgenomen kunnen wordenerror46: Er zijn geen Provinciecodes gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\GetProvinciecodesRequest $request_parameters
     * @return \RelatieApiV6\StructType\GetProvinciecodesResponse|bool
     */
    public function getProvinciecodes(\RelatieApiV6\StructType\GetProvinciecodesRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getProvinciecodes($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRelatietype
     * Meta information extracted from the WSDL
     * - documentation: Bepalen wat voor type relatie aangemaakt is onder een bepaald relatienummererror15: Er is geen relatienummer opgegevenerror16: Op basis van het relatienummer is geen relatie gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\GetRelatietypeRequest $request_parameters
     * @return \RelatieApiV6\StructType\GetRelatietypeResponse|bool
     */
    public function getRelatietype(\RelatieApiV6\StructType\GetRelatietypeRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getRelatietype($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPersoon
     * Meta information extracted from the WSDL
     * - documentation: Ophalen van de gegevens van een persoonerror15: Er is geen relatienummer opgegevenerror16: Op basis van het relatienummer is geen relatie gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\GetPersoonRequest $request_parameters
     * @return \RelatieApiV6\StructType\GetPersoonResponse|bool
     */
    public function getPersoon(\RelatieApiV6\StructType\GetPersoonRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPersoon($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPersonen
     * Meta information extracted from the WSDL
     * - documentation: Ophalen van een lijst met gegevens van een persoonerror15: Er is geen relatienummer opgegevenerror16: Op basis van het relatienummer is geen relatie gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\GetPersonenRequest $request_parameters
     * @return \RelatieApiV6\StructType\GetPersonenResponse|bool
     */
    public function getPersonen(\RelatieApiV6\StructType\GetPersonenRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPersonen($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBedrijf
     * Meta information extracted from the WSDL
     * - documentation: Ophalen van de gegevens van een bedrijferror15: Er is geen relatienummer opgegevenerror16: Op basis van het relatienummer is geen relatie gevondenerror68: De relatie met het opgegeven relatienummer is niet van het type 'Persoon'.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\GetBedrijfRequest $request_parameters
     * @return \RelatieApiV6\StructType\GetBedrijfResponse|bool
     */
    public function getBedrijf(\RelatieApiV6\StructType\GetBedrijfRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBedrijf($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getContactpersoon
     * Meta information extracted from the WSDL
     * - documentation: Ophalen van de gegevens van een contactpersoonerror15: Er is geen relatienummer opgegevenerror16: Op basis van het relatienummer is geen relatie gevondenerror69: De relatie met het opgegeven relatienummer is niet van het type
     * 'Bedrijf'.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\GetContactpersoonRequest $request_parameters
     * @return \RelatieApiV6\StructType\GetContactpersoonResponse|bool
     */
    public function getContactpersoon(\RelatieApiV6\StructType\GetContactpersoonRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getContactpersoon($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAfdeling
     * Meta information extracted from the WSDL
     * - documentation: Ophalen van de gegevens van een afdelingerror15: Er is geen relatienummer opgegevenerror16: Op basis van het relatienummer is geen relatie gevondenerror70: De relatie met het opgegeven relatienummer is niet van het type
     * 'Contactpersoon'.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\GetAfdelingRequest $request_parameters
     * @return \RelatieApiV6\StructType\GetAfdelingResponse|bool
     */
    public function getAfdeling(\RelatieApiV6\StructType\GetAfdelingRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAfdeling($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBedrijfInclCont
     * Meta information extracted from the WSDL
     * - documentation: Ophalen van de gegevens van een gecombineerde bedrijf en/of contactpersoon relatie (waarbij zowel bedrijf als persoonsgegevens op 1 relatiekaart staan). Kan alleen gebruikt worden indien systeem-constante "Invoer van bedrijven op de
     * relatiekaart inclusief contactpersoon" geactiveerd is.error15: Er is geen relatienummer opgegevenerror16: Op basis van het relatienummer is geen relatie gevondenerror106: Zeno is niet ingesteld om te werken met relatiekaarten met gecombineerde
     * bedrijf en persoons gegevenserror109: De relatie met het opgegeven relatienummer is niet van het type 'Bedrijf inclusief contactpersoon'
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\GetBedrijfInclContRequest $request_parameters
     * @return \RelatieApiV6\StructType\GetBedrijfInclContResponse|bool
     */
    public function getBedrijfInclCont(\RelatieApiV6\StructType\GetBedrijfInclContRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBedrijfInclCont($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRelatieKortinggroepen
     * Meta information extracted from the WSDL
     * - documentation: Ophalen van een lijst met beschikbare relatiekortinggroepenerror47: Er zijn geen relatiekortinggroepen gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\GetRelatieKortinggroepenRequest $request_parameters
     * @return \RelatieApiV6\StructType\GetRelatieKortinggroepenResponse|bool
     */
    public function getRelatieKortinggroepen(\RelatieApiV6\StructType\GetRelatieKortinggroepenRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getRelatieKortinggroepen($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getNetnummers
     * Meta information extracted from the WSDL
     * - documentation: Ophalen van een lijst met beschikbare netnummers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\GetNetnummersRequest $request_parameters
     * @return \RelatieApiV6\StructType\GetNetnummersResponse|bool
     */
    public function getNetnummers(\RelatieApiV6\StructType\GetNetnummersRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getNetnummers($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getActiviteittypen
     * Meta information extracted from the WSDL
     * - documentation: Ophalen van een lijst met beschikbare activiteittypen
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\GetActiviteittypenRequest $request_parameters
     * @return \RelatieApiV6\StructType\GetActiviteittypenResponse|bool
     */
    public function getActiviteittypen(\RelatieApiV6\StructType\GetActiviteittypenRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getActiviteittypen($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAdres
     * Meta information extracted from the WSDL
     * - documentation: Ophalen van het adres voor een relatie. Hierbij wordt gebruik gemaakt van de 'etiket' functionaliteit van Zeno. In geval de relatie een contactpersoon of afdeling van een bedrijf is, en er bij de contactpersoon of afdeling geen adres
     * opgegeven is, wordt het adres van het bedrijf afgehaald. <br/><br/> Ook zal bijvoorbeeld bij opvragen van het correspondentieadres het bezoekadres geretourneerd worden indien alleen een bezoekadres opgegeven is.<br/><br/> N.B. Aangezien het adres
     * mogelijk vanaf een andere relatie (het bedrijf) opgehaald kan worden dan het opgegeven relatienummer dient het geretourneerde adres in geen geval gebruikt te worden voor het bijwerken van de relatie behorende bij het opgegeven relatienummer.error16:
     * Op basis van het relatienummer is geen relatie gevondenerror60: Het opgegeven adrestype is onbekend
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\GetAdresRequest $request_parameters
     * @return \RelatieApiV6\StructType\GetAdresResponse|bool
     */
    public function getAdres(\RelatieApiV6\StructType\GetAdresRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getAdres($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBicVanIban
     * Meta information extracted from the WSDL
     * - documentation: Geeft de BIC van de bank terug adhv een IBAN-rekeningnummererror39: Het opgegeven IBAN nummer voldoet niet aan de eisenerror62: Kan geen BIC vinden op basis van het opgegeven IBAN rekeningnummer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\GetBicVanIbanRequest $request_parameters
     * @return \RelatieApiV6\StructType\GetBicVanIbanResponse|bool
     */
    public function getBicVanIban(\RelatieApiV6\StructType\GetBicVanIbanRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getBicVanIban($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getIbanVanBankrekening
     * Meta information extracted from the WSDL
     * - documentation: Geeft van een opgegeven bankrekening, de IBAN en BIC gegevens terug.<br/> Afhankelijk van wat er in Zeno is ingesteld, wordt dit via iban-converteren.nl of via openiban.nl bepaald.error37: Het opgegeven bankrekeningnummer voldoet
     * niet aan de 11-proeferror63: Er is geen conversiepartner in Zeno opgegeven om een bankrekeningnummer naar een iban-rekeningnummer om te zetten
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\GetIbanVanBankrekeningRequest $request_parameters
     * @return \RelatieApiV6\StructType\GetIbanVanBankrekeningResponse|bool
     */
    public function getIbanVanBankrekening(\RelatieApiV6\StructType\GetIbanVanBankrekeningRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getIbanVanBankrekening($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSmartcodeByRelNo
     * Meta information extracted from the WSDL
     * - documentation: Geeft de smartcode van een relatie nummer terug.error104: Op basis van het relatie nummer is geen smartcode gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\GetSmartcodeByRelNoRequest $request_parameters
     * @return \RelatieApiV6\StructType\GetSmartcodeByRelNoResponse|bool
     */
    public function getSmartcodeByRelNo(\RelatieApiV6\StructType\GetSmartcodeByRelNoRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getSmartcodeByRelNo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getKenmerken
     * Meta information extracted from the WSDL
     * - documentation: Geeft de beschikbare kenmerk-stamgegevens terugerror1110: Er is een onbekende kenmerkgroep meegegevenerror1111: De opgegeven kenmerkgroep is niet-actief
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\GetKenmerkenRequest $request_parameters
     * @return \RelatieApiV6\StructType\GetKenmerkenResponse|bool
     */
    public function getKenmerken(\RelatieApiV6\StructType\GetKenmerkenRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getKenmerken($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRelatieManager
     * Meta information extracted from the WSDL
     * - documentation: Geeft o.b.v. een relatienummer de manager terug.error16: Op basis van het relatienummer is geen relatie gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\GetRelatieManagerRequest $request_parameters
     * @return \RelatieApiV6\StructType\GetRelatieManagerResponse|bool
     */
    public function getRelatieManager(\RelatieApiV6\StructType\GetRelatieManagerRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getRelatieManager($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRelatieRayon
     * Meta information extracted from the WSDL
     * - documentation: Geeft o.b.v. een relatienummer de rayon code en de rayon naam terug.error16: Op basis van het relatienummer is geen relatie gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\GetRelatieRayonRequest $request_parameters
     * @return \RelatieApiV6\StructType\GetRelatieRayonResponse|bool
     */
    public function getRelatieRayon(\RelatieApiV6\StructType\GetRelatieRayonRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getRelatieRayon($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVerbandInfo
     * Meta information extracted from the WSDL
     * - documentation: Geeft een lijst met gekoppelde relatieverbanden terug. <br/> <br/><u>Let op:</u> Deze operatie was voorheen onderdeel van de WebApiV4, maar is verplaatst naar de RelatieApiV6 omdat het relatie-gegevens betreft.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\GetVerbandInfoRequest $request_parameters
     * @return \RelatieApiV6\StructType\GetVerbandInfoResponse|bool
     */
    public function getVerbandInfo(\RelatieApiV6\StructType\GetVerbandInfoRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getVerbandInfo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getKenmerkInfo
     * Meta information extracted from the WSDL
     * - documentation: Geeft de kenmerken terug die gekoppeld zijn aan een bepaalde relatie. <br/> <br/><u>Let op:</u> Deze operatie was voorheen onderdeel van de WebApiV4, maar is verplaatst naar de RelatieApiV6 omdat het relatie-gegevens betreft.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\GetKenmerkInfoRequest $request_parameters
     * @return \RelatieApiV6\StructType\GetKenmerkInfoResponse|bool
     */
    public function getKenmerkInfo(\RelatieApiV6\StructType\GetKenmerkInfoRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getKenmerkInfo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getKlantKenmerk
     * Meta information extracted from the WSDL
     * - documentation: Controleert of de relatie een opgegeven kenmerk heeft. <br/> <br/><u>Let op:</u> Deze operatie was voorheen onderdeel van de WebApiV4, maar is verplaatst naar de RelatieApiV6 omdat het relatie-gegevens betreft.error5: De relatie is
     * niet gevondenerror19: Er is geen relatie opgegevenerror173: Er is geen kenmerk opgegevenerror174: Het kenmerk is niet gevondenerror178: Er is geen kenmerkgroep opgegevenerror179: De kenmerkgroep is niet gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\GetKlantKenmerkRequest $request_parameters
     * @return \RelatieApiV6\StructType\GetKlantKenmerkResponse|bool
     */
    public function getKlantKenmerk(\RelatieApiV6\StructType\GetKlantKenmerkRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getKlantKenmerk($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPostcodeInfo
     * Meta information extracted from the WSDL
     * - documentation: Geeft de straat en huisnummer terug die behoort bij de opgegeven postcode en huisnummer combinatie. Deze operatie werkt alleen indien er een postcodetabel van Cendris in Zeno is geimporteerd of gebruik wordt gemaakt van AdresXpress
     * van Cendris of PostcodeApi.nu. <br/> <br/>Indien gebruik wordt gemaakt van PostcodeApi.nu, wordt geen straat- en plaats gevonden voor postbus-adressen omdat PostcodeApi.nu gebruik maakt van de gegevens uit de Basisadministratie Gemeenten (BAG). <br/>
     * <br/><u>Let op:</u> Deze operatie was voorheen onderdeel van de WebApiV4, maar is verplaatst naar de RelatieApiV6 omdat het relatie-gegevens betreft.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\GetPostcodeInfoRequest $request_parameters
     * @return \RelatieApiV6\StructType\GetPostcodeInfoResponse|bool
     */
    public function getPostcodeInfo(\RelatieApiV6\StructType\GetPostcodeInfoRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPostcodeInfo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPrivacyCats
     * Meta information extracted from the WSDL
     * - documentation: Ophalen van stamgegevens voor privacy categorieen, met een optionele selectie mogelijkheid op hoofd-categorie en categorie. De complete hierarchie <br/>- Hoofd privacy categorie, <br/>- Privacy categorie en <br/>- Sub privacy
     * categorie <br/>wordt opgehaald.error180: De opgegeven hoofd privacy categorie code kan niet worden gevonden.error181: De opgegeven hoofd privacy categorie code komt meerdere keren voor.error182: Als er een privacy categorie code is opgegeven, moet er
     * ook een hoofd privacy categorie worden opgegeven.error183: De opgegeven privacy categorie code kan niet worden gevonden.error184: De opgegeven privacy categorie code komt meerdere keren voor.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\GetPrivacyCatsRequest $request_parameters
     * @return \RelatieApiV6\StructType\GetPrivacyCatsResponse|bool
     */
    public function getPrivacyCats(\RelatieApiV6\StructType\GetPrivacyCatsRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPrivacyCats($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPrivacySubCats
     * Meta information extracted from the WSDL
     * - documentation: Ophalen van stamgegevens voor mogelijk privacy sub categorieen, met een verplichte selectie op hoofd categorie en categorie. Alleen de privacy sub categorieen worden opgehaald.error180: De opgegeven hoofd privacy categorie code kan
     * niet worden gevonden.error181: De opgegeven hoofd privacy categorie code komt meerdere keren voor.error182: Als er een privacy categorie code is opgegeven, moet er ook een hoofd privacy categorie worden opgegeven.error183: De opgegeven privacy
     * categorie code kan niet worden gevonden.error184: De opgegeven privacy categorie code komt meerdere keren voor.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\GetPrivacySubCatsRequest $request_parameters
     * @return \RelatieApiV6\StructType\GetPrivacySubCatsResponse|bool
     */
    public function getPrivacySubCats(\RelatieApiV6\StructType\GetPrivacySubCatsRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getPrivacySubCats($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRelatiePrivacyCats
     * Meta information extracted from the WSDL
     * - documentation: Ophalen van privacy categorieen van het opgegeven relatienummer, met een optionele selectie mogelijkheid op hoofd categorie en categorie.error16: Op basis van het relatienummer is geen relatie gevonden.error180: De opgegeven hoofd
     * privacy categorie code kan niet worden gevonden.error181: De opgegeven hoofd privacy categorie code komt meerdere keren voor.error182: Als er een privacy categorie code is opgegeven, moet er ook een hoofd privacy categorie worden opgegeven.error183:
     * De opgegeven privacy categorie code kan niet worden gevonden.error184: De opgegeven privacy categorie code komt meerdere keren voor.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \RelatieApiV6\StructType\GetRelatiePrivacyCatsRequest $request_parameters
     * @return \RelatieApiV6\StructType\GetRelatiePrivacyCatsResponse|bool
     */
    public function getRelatiePrivacyCats(\RelatieApiV6\StructType\GetRelatiePrivacyCatsRequest $request_parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getRelatiePrivacyCats($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \RelatieApiV6\StructType\GetActiviteittypenResponse|\RelatieApiV6\StructType\GetAdresResponse|\RelatieApiV6\StructType\GetAfdelingResponse|\RelatieApiV6\StructType\GetBedrijfInclContResponse|\RelatieApiV6\StructType\GetBedrijfResponse|\RelatieApiV6\StructType\GetBiccodesResponse|\RelatieApiV6\StructType\GetBicVanIbanResponse|\RelatieApiV6\StructType\GetContactpersoonResponse|\RelatieApiV6\StructType\GetFunctiesResponse|\RelatieApiV6\StructType\GetIbanVanBankrekeningResponse|\RelatieApiV6\StructType\GetKenmerkenResponse|\RelatieApiV6\StructType\GetKenmerkInfoResponse|\RelatieApiV6\StructType\GetKlantKenmerkResponse|\RelatieApiV6\StructType\GetLandcodesResponse|\RelatieApiV6\StructType\GetNetnummersResponse|\RelatieApiV6\StructType\GetPersonenResponse|\RelatieApiV6\StructType\GetPersoonResponse|\RelatieApiV6\StructType\GetPostcodeInfoResponse|\RelatieApiV6\StructType\GetPrivacyCatsResponse|\RelatieApiV6\StructType\GetPrivacySubCatsResponse|\RelatieApiV6\StructType\GetProvinciecodesResponse|\RelatieApiV6\StructType\GetRelatieKortinggroepenResponse|\RelatieApiV6\StructType\GetRelatieManagerResponse|\RelatieApiV6\StructType\GetRelatiePrivacyCatsResponse|\RelatieApiV6\StructType\GetRelatieRayonResponse|\RelatieApiV6\StructType\GetRelatietypeResponse|\RelatieApiV6\StructType\GetSmartcodeByRelNoResponse|\RelatieApiV6\StructType\GetTaalcodesResponse|\RelatieApiV6\StructType\GetTitulatuurcodesResponse|\RelatieApiV6\StructType\GetVerbandInfoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
