<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VrijNumeriekveldRec StructType
 * Meta information extracted from the WSDL
 * - documentation: Vrij numerieke veld
 * @subpackage Structs
 * @date 20240419 package
 */
class VrijNumeriekveldRec extends AbstractStructBase
{
    /**
     * The label
     * Meta information extracted from the WSDL
     * - documentation: Label voor het vrije veld
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $label;
    /**
     * The waarde
     * Meta information extracted from the WSDL
     * - documentation: Waarde van het vrije veld
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $waarde;
    /**
     * Constructor method for VrijNumeriekveldRec
     * @uses VrijNumeriekveldRec::setLabel()
     * @uses VrijNumeriekveldRec::setWaarde()
     * @param string $label
     * @param float $waarde
     */
    public function __construct($label = null, $waarde = null)
    {
        $this
            ->setLabel($label)
            ->setWaarde($waarde);
    }
    /**
     * Get label value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLabel()
    {
        return isset($this->label) ? $this->label : null;
    }
    /**
     * Set label value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $label
     * @return \RelatieApiV6\StructType\VrijNumeriekveldRec
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($label) && mb_strlen($label) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($label)), __LINE__);
        }
        if (is_null($label) || (is_array($label) && empty($label))) {
            unset($this->label);
        } else {
            $this->label = $label;
        }
        return $this;
    }
    /**
     * Get waarde value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getWaarde()
    {
        return isset($this->waarde) ? $this->waarde : null;
    }
    /**
     * Set waarde value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $waarde
     * @return \RelatieApiV6\StructType\VrijNumeriekveldRec
     */
    public function setWaarde($waarde = null)
    {
        // validation for constraint: float
        if (!is_null($waarde) && !(is_float($waarde) || is_numeric($waarde))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($waarde, true), gettype($waarde)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($waarde) && mb_strlen(mb_substr($waarde, false !== mb_strpos($waarde, '.') ? mb_strpos($waarde, '.') + 1 : mb_strlen($waarde))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($waarde, true), mb_strlen(mb_substr($waarde, mb_strpos($waarde, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($waarde) && mb_strlen(preg_replace('/(\D)/', '', $waarde)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($waarde, true), mb_strlen(preg_replace('/(\D)/', '', $waarde))), __LINE__);
        }
        if (is_null($waarde) || (is_array($waarde) && empty($waarde))) {
            unset($this->waarde);
        } else {
            $this->waarde = $waarde;
        }
        return $this;
    }
}
