<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TitulatuurcodeRec StructType
 * Meta information extracted from the WSDL
 * - documentation: Titulatuurgegevens
 * @subpackage Structs
 * @date 20240419 package
 */
class TitulatuurcodeRec extends AbstractStructBase
{
    /**
     * The titulatuurCode
     * Meta information extracted from the WSDL
     * - documentation: De code van de titulatuur
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $titulatuurCode;
    /**
     * The titulatuurOmschrijving
     * Meta information extracted from the WSDL
     * - documentation: Omschrijving van de titulatuur
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $titulatuurOmschrijving;
    /**
     * Constructor method for TitulatuurcodeRec
     * @uses TitulatuurcodeRec::setTitulatuurCode()
     * @uses TitulatuurcodeRec::setTitulatuurOmschrijving()
     * @param string $titulatuurCode
     * @param string $titulatuurOmschrijving
     */
    public function __construct($titulatuurCode = null, $titulatuurOmschrijving = null)
    {
        $this
            ->setTitulatuurCode($titulatuurCode)
            ->setTitulatuurOmschrijving($titulatuurOmschrijving);
    }
    /**
     * Get titulatuurCode value
     * @return string
     */
    public function getTitulatuurCode()
    {
        return $this->titulatuurCode;
    }
    /**
     * Set titulatuurCode value
     * @param string $titulatuurCode
     * @return \RelatieApiV6\StructType\TitulatuurcodeRec
     */
    public function setTitulatuurCode($titulatuurCode = null)
    {
        // validation for constraint: string
        if (!is_null($titulatuurCode) && !is_string($titulatuurCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($titulatuurCode, true), gettype($titulatuurCode)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($titulatuurCode) && mb_strlen($titulatuurCode) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($titulatuurCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($titulatuurCode) && mb_strlen($titulatuurCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($titulatuurCode)), __LINE__);
        }
        $this->titulatuurCode = $titulatuurCode;
        return $this;
    }
    /**
     * Get titulatuurOmschrijving value
     * @return string
     */
    public function getTitulatuurOmschrijving()
    {
        return $this->titulatuurOmschrijving;
    }
    /**
     * Set titulatuurOmschrijving value
     * @param string $titulatuurOmschrijving
     * @return \RelatieApiV6\StructType\TitulatuurcodeRec
     */
    public function setTitulatuurOmschrijving($titulatuurOmschrijving = null)
    {
        // validation for constraint: string
        if (!is_null($titulatuurOmschrijving) && !is_string($titulatuurOmschrijving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($titulatuurOmschrijving, true), gettype($titulatuurOmschrijving)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($titulatuurOmschrijving) && mb_strlen($titulatuurOmschrijving) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($titulatuurOmschrijving)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($titulatuurOmschrijving) && mb_strlen($titulatuurOmschrijving) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($titulatuurOmschrijving)), __LINE__);
        }
        $this->titulatuurOmschrijving = $titulatuurOmschrijving;
        return $this;
    }
}
