<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for setOptInOutRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Bij een bestaande relatie de indicatie 'uitsluiten voor mailing' of 'recht van beperking' aan- of uitzetten.
 * @subpackage Structs
 * @date 20240419 package
 */
class SetOptInOutRequest extends AbstractStructBase
{
    /**
     * The relNo
     * Meta information extracted from the WSDL
     * - documentation: Relatienummer van de relatie waar de indicatie gezet moet worden.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relNo;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - documentation: Welk veld moet worden gezet, MAILINGS = Uitsluiten voor mailings, BEPERKING = Recht van beperking. In oudere versies bestond ook het type QUESTIONNAIRES = Uitsluiten voor enquetes, maar dit levert vanaf versie 4.36.0 een foutmelding
     * op. Neem in dat geval contact op met Socho_IT.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $type;
    /**
     * The waarde
     * Meta information extracted from the WSDL
     * - documentation: Indicatie of de het veld aan of uit gezet moet worden, false = uit, true = aan.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var bool
     */
    public $waarde;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * Constructor method for setOptInOutRequest
     * @uses SetOptInOutRequest::setRelNo()
     * @uses SetOptInOutRequest::setType()
     * @uses SetOptInOutRequest::setWaarde()
     * @uses SetOptInOutRequest::setRequestTag()
     * @param int $relNo
     * @param string $type
     * @param bool $waarde
     * @param string $requestTag
     */
    public function __construct($relNo = null, $type = null, $waarde = null, $requestTag = null)
    {
        $this
            ->setRelNo($relNo)
            ->setType($type)
            ->setWaarde($waarde)
            ->setRequestTag($requestTag);
    }
    /**
     * Get relNo value
     * @return int
     */
    public function getRelNo()
    {
        return $this->relNo;
    }
    /**
     * Set relNo value
     * @param int $relNo
     * @return \RelatieApiV6\StructType\SetOptInOutRequest
     */
    public function setRelNo($relNo = null)
    {
        // validation for constraint: int
        if (!is_null($relNo) && !(is_int($relNo) || ctype_digit($relNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNo, true), gettype($relNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNo) && mb_strlen(preg_replace('/(\D)/', '', $relNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNo, true), mb_strlen(preg_replace('/(\D)/', '', $relNo))), __LINE__);
        }
        $this->relNo = $relNo;
        return $this;
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \RelatieApiV6\StructType\SetOptInOutRequest
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($type) && mb_strlen($type) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($type)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($type) && mb_strlen($type) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get waarde value
     * @return bool
     */
    public function getWaarde()
    {
        return $this->waarde;
    }
    /**
     * Set waarde value
     * @param bool $waarde
     * @return \RelatieApiV6\StructType\SetOptInOutRequest
     */
    public function setWaarde($waarde = null)
    {
        // validation for constraint: boolean
        if (!is_null($waarde) && !is_bool($waarde)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($waarde, true), gettype($waarde)), __LINE__);
        }
        $this->waarde = $waarde;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\SetOptInOutRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
}
