<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelatieKenmerk StructType
 * Meta information extracted from the WSDL
 * - documentation: Kenmerk object.
 * @subpackage Structs
 * @date 20240419 package
 */
class RelatieKenmerk extends AbstractStructBase
{
    /**
     * The kenmerkCode
     * Meta information extracted from the WSDL
     * - documentation: Code van het kenmerk.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $kenmerkCode;
    /**
     * The kenmerkGroepCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de kenmerkgroep van het kenmerk.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $kenmerkGroepCode;
    /**
     * The kenmerkNo
     * Meta information extracted from the WSDL
     * - documentation: Nummer van het kenmerk, eventueel te gebruiken bij deleteKenmerk.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $kenmerkNo;
    /**
     * The relNo
     * Meta information extracted from the WSDL
     * - documentation: Nummer van de relatie waaraan het kenmerk gekoppeld is.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relNo;
    /**
     * Constructor method for RelatieKenmerk
     * @uses RelatieKenmerk::setKenmerkCode()
     * @uses RelatieKenmerk::setKenmerkGroepCode()
     * @uses RelatieKenmerk::setKenmerkNo()
     * @uses RelatieKenmerk::setRelNo()
     * @param string $kenmerkCode
     * @param string $kenmerkGroepCode
     * @param int $kenmerkNo
     * @param int $relNo
     */
    public function __construct($kenmerkCode = null, $kenmerkGroepCode = null, $kenmerkNo = null, $relNo = null)
    {
        $this
            ->setKenmerkCode($kenmerkCode)
            ->setKenmerkGroepCode($kenmerkGroepCode)
            ->setKenmerkNo($kenmerkNo)
            ->setRelNo($relNo);
    }
    /**
     * Get kenmerkCode value
     * @return string
     */
    public function getKenmerkCode()
    {
        return $this->kenmerkCode;
    }
    /**
     * Set kenmerkCode value
     * @param string $kenmerkCode
     * @return \RelatieApiV6\StructType\RelatieKenmerk
     */
    public function setKenmerkCode($kenmerkCode = null)
    {
        // validation for constraint: string
        if (!is_null($kenmerkCode) && !is_string($kenmerkCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kenmerkCode, true), gettype($kenmerkCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($kenmerkCode) && mb_strlen($kenmerkCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($kenmerkCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($kenmerkCode) && mb_strlen($kenmerkCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($kenmerkCode)), __LINE__);
        }
        $this->kenmerkCode = $kenmerkCode;
        return $this;
    }
    /**
     * Get kenmerkGroepCode value
     * @return string
     */
    public function getKenmerkGroepCode()
    {
        return $this->kenmerkGroepCode;
    }
    /**
     * Set kenmerkGroepCode value
     * @param string $kenmerkGroepCode
     * @return \RelatieApiV6\StructType\RelatieKenmerk
     */
    public function setKenmerkGroepCode($kenmerkGroepCode = null)
    {
        // validation for constraint: string
        if (!is_null($kenmerkGroepCode) && !is_string($kenmerkGroepCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kenmerkGroepCode, true), gettype($kenmerkGroepCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($kenmerkGroepCode) && mb_strlen($kenmerkGroepCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($kenmerkGroepCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($kenmerkGroepCode) && mb_strlen($kenmerkGroepCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($kenmerkGroepCode)), __LINE__);
        }
        $this->kenmerkGroepCode = $kenmerkGroepCode;
        return $this;
    }
    /**
     * Get kenmerkNo value
     * @return int
     */
    public function getKenmerkNo()
    {
        return $this->kenmerkNo;
    }
    /**
     * Set kenmerkNo value
     * @param int $kenmerkNo
     * @return \RelatieApiV6\StructType\RelatieKenmerk
     */
    public function setKenmerkNo($kenmerkNo = null)
    {
        // validation for constraint: int
        if (!is_null($kenmerkNo) && !(is_int($kenmerkNo) || ctype_digit($kenmerkNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kenmerkNo, true), gettype($kenmerkNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($kenmerkNo) && mb_strlen(preg_replace('/(\D)/', '', $kenmerkNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($kenmerkNo, true), mb_strlen(preg_replace('/(\D)/', '', $kenmerkNo))), __LINE__);
        }
        $this->kenmerkNo = $kenmerkNo;
        return $this;
    }
    /**
     * Get relNo value
     * @return int
     */
    public function getRelNo()
    {
        return $this->relNo;
    }
    /**
     * Set relNo value
     * @param int $relNo
     * @return \RelatieApiV6\StructType\RelatieKenmerk
     */
    public function setRelNo($relNo = null)
    {
        // validation for constraint: int
        if (!is_null($relNo) && !(is_int($relNo) || ctype_digit($relNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNo, true), gettype($relNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNo) && mb_strlen(preg_replace('/(\D)/', '', $relNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNo, true), mb_strlen(preg_replace('/(\D)/', '', $relNo))), __LINE__);
        }
        $this->relNo = $relNo;
        return $this;
    }
}
