<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelatieFunctietable StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met aan de relatie gekoppelde functies
 * @subpackage Structs
 * @date 20240419 package
 */
class RelatieFunctietable extends AbstractStructBase
{
    /**
     * The relatieFunctie
     * Meta information extracted from the WSDL
     * - documentation: Functies
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \RelatieApiV6\StructType\RelatieFunctieRec[]
     */
    public $relatieFunctie;
    /**
     * Constructor method for RelatieFunctietable
     * @uses RelatieFunctietable::setRelatieFunctie()
     * @param \RelatieApiV6\StructType\RelatieFunctieRec[] $relatieFunctie
     */
    public function __construct(array $relatieFunctie = array())
    {
        $this
            ->setRelatieFunctie($relatieFunctie);
    }
    /**
     * Get relatieFunctie value
     * @return \RelatieApiV6\StructType\RelatieFunctieRec[]|null
     */
    public function getRelatieFunctie()
    {
        return $this->relatieFunctie;
    }
    /**
     * This method is responsible for validating the values passed to the setRelatieFunctie method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelatieFunctie method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelatieFunctieForArrayConstraintsFromSetRelatieFunctie(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $relatieFunctietableRelatieFunctieItem) {
            // validation for constraint: itemType
            if (!$relatieFunctietableRelatieFunctieItem instanceof \RelatieApiV6\StructType\RelatieFunctieRec) {
                $invalidValues[] = is_object($relatieFunctietableRelatieFunctieItem) ? get_class($relatieFunctietableRelatieFunctieItem) : sprintf('%s(%s)', gettype($relatieFunctietableRelatieFunctieItem), var_export($relatieFunctietableRelatieFunctieItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The relatieFunctie property can only contain items of type \RelatieApiV6\StructType\RelatieFunctieRec, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set relatieFunctie value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV6\StructType\RelatieFunctieRec[] $relatieFunctie
     * @return \RelatieApiV6\StructType\RelatieFunctietable
     */
    public function setRelatieFunctie(array $relatieFunctie = array())
    {
        // validation for constraint: array
        if ('' !== ($relatieFunctieArrayErrorMessage = self::validateRelatieFunctieForArrayConstraintsFromSetRelatieFunctie($relatieFunctie))) {
            throw new \InvalidArgumentException($relatieFunctieArrayErrorMessage, __LINE__);
        }
        $this->relatieFunctie = $relatieFunctie;
        return $this;
    }
    /**
     * Add item to relatieFunctie value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV6\StructType\RelatieFunctieRec $item
     * @return \RelatieApiV6\StructType\RelatieFunctietable
     */
    public function addToRelatieFunctie(\RelatieApiV6\StructType\RelatieFunctieRec $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RelatieApiV6\StructType\RelatieFunctieRec) {
            throw new \InvalidArgumentException(sprintf('The relatieFunctie property can only contain items of type \RelatieApiV6\StructType\RelatieFunctieRec, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->relatieFunctie[] = $item;
        return $this;
    }
}
