<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrivacyCat StructType
 * Meta information extracted from the WSDL
 * - documentation: Privacy categorie object.
 * @subpackage Structs
 * @date 20240419 package
 */
class PrivacyCat extends AbstractStructBase
{
    /**
     * The privacyCatCode
     * Meta information extracted from the WSDL
     * - documentation: Code van de privacy categorie.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $privacyCatCode;
    /**
     * The privacyCatDefault
     * Meta information extracted from the WSDL
     * - documentation: Default status (0=Onbekend, 1=Niet benaderen, 2=Benaderen).
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 1
     * @var int
     */
    public $privacyCatDefault;
    /**
     * The privacyCatNaam
     * Meta information extracted from the WSDL
     * - documentation: Naam van de privacy categorie.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $privacyCatNaam;
    /**
     * The privacySubCats
     * Meta information extracted from the WSDL
     * - documentation: Lijst van de mogelijke privacy sub categorieen, bij deze categorie.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\PrivacySubCatInfo
     */
    public $privacySubCats;
    /**
     * Constructor method for PrivacyCat
     * @uses PrivacyCat::setPrivacyCatCode()
     * @uses PrivacyCat::setPrivacyCatDefault()
     * @uses PrivacyCat::setPrivacyCatNaam()
     * @uses PrivacyCat::setPrivacySubCats()
     * @param string $privacyCatCode
     * @param int $privacyCatDefault
     * @param string $privacyCatNaam
     * @param \RelatieApiV6\StructType\PrivacySubCatInfo $privacySubCats
     */
    public function __construct($privacyCatCode = null, $privacyCatDefault = null, $privacyCatNaam = null, \RelatieApiV6\StructType\PrivacySubCatInfo $privacySubCats = null)
    {
        $this
            ->setPrivacyCatCode($privacyCatCode)
            ->setPrivacyCatDefault($privacyCatDefault)
            ->setPrivacyCatNaam($privacyCatNaam)
            ->setPrivacySubCats($privacySubCats);
    }
    /**
     * Get privacyCatCode value
     * @return string
     */
    public function getPrivacyCatCode()
    {
        return $this->privacyCatCode;
    }
    /**
     * Set privacyCatCode value
     * @param string $privacyCatCode
     * @return \RelatieApiV6\StructType\PrivacyCat
     */
    public function setPrivacyCatCode($privacyCatCode = null)
    {
        // validation for constraint: string
        if (!is_null($privacyCatCode) && !is_string($privacyCatCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($privacyCatCode, true), gettype($privacyCatCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($privacyCatCode) && mb_strlen($privacyCatCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($privacyCatCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($privacyCatCode) && mb_strlen($privacyCatCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($privacyCatCode)), __LINE__);
        }
        $this->privacyCatCode = $privacyCatCode;
        return $this;
    }
    /**
     * Get privacyCatDefault value
     * @return int
     */
    public function getPrivacyCatDefault()
    {
        return $this->privacyCatDefault;
    }
    /**
     * Set privacyCatDefault value
     * @param int $privacyCatDefault
     * @return \RelatieApiV6\StructType\PrivacyCat
     */
    public function setPrivacyCatDefault($privacyCatDefault = null)
    {
        // validation for constraint: int
        if (!is_null($privacyCatDefault) && !(is_int($privacyCatDefault) || ctype_digit($privacyCatDefault))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($privacyCatDefault, true), gettype($privacyCatDefault)), __LINE__);
        }
        // validation for constraint: totalDigits(1)
        if (!is_null($privacyCatDefault) && mb_strlen(preg_replace('/(\D)/', '', $privacyCatDefault)) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 1 digits, "%d" given', var_export($privacyCatDefault, true), mb_strlen(preg_replace('/(\D)/', '', $privacyCatDefault))), __LINE__);
        }
        $this->privacyCatDefault = $privacyCatDefault;
        return $this;
    }
    /**
     * Get privacyCatNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrivacyCatNaam()
    {
        return isset($this->privacyCatNaam) ? $this->privacyCatNaam : null;
    }
    /**
     * Set privacyCatNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $privacyCatNaam
     * @return \RelatieApiV6\StructType\PrivacyCat
     */
    public function setPrivacyCatNaam($privacyCatNaam = null)
    {
        // validation for constraint: string
        if (!is_null($privacyCatNaam) && !is_string($privacyCatNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($privacyCatNaam, true), gettype($privacyCatNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($privacyCatNaam) && mb_strlen($privacyCatNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($privacyCatNaam)), __LINE__);
        }
        if (is_null($privacyCatNaam) || (is_array($privacyCatNaam) && empty($privacyCatNaam))) {
            unset($this->privacyCatNaam);
        } else {
            $this->privacyCatNaam = $privacyCatNaam;
        }
        return $this;
    }
    /**
     * Get privacySubCats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\PrivacySubCatInfo|null
     */
    public function getPrivacySubCats()
    {
        return isset($this->privacySubCats) ? $this->privacySubCats : null;
    }
    /**
     * Set privacySubCats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\PrivacySubCatInfo $privacySubCats
     * @return \RelatieApiV6\StructType\PrivacyCat
     */
    public function setPrivacySubCats(\RelatieApiV6\StructType\PrivacySubCatInfo $privacySubCats = null)
    {
        if (is_null($privacySubCats) || (is_array($privacySubCats) && empty($privacySubCats))) {
            unset($this->privacySubCats);
        } else {
            $this->privacySubCats = $privacySubCats;
        }
        return $this;
    }
}
