<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersooninfoRec StructType
 * Meta information extracted from the WSDL
 * - documentation: Persoongegevens
 * @subpackage Structs
 * @date 20240419 package
 */
class PersooninfoRec extends AbstractStructBase
{
    /**
     * The persoon
     * Meta information extracted from the WSDL
     * - documentation: De gegevens van de persoon
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\PersoonRec
     */
    public $persoon;
    /**
     * The leververbod
     * Meta information extracted from the WSDL
     * - documentation: De persoon heeft een leververbod
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $leververbod;
    /**
     * The functies
     * Meta information extracted from the WSDL
     * - documentation: De functies van de persoon
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\RelatieFunctietable
     */
    public $functies;
    /**
     * The biccodes
     * Meta information extracted from the WSDL
     * - documentation: De biccodes van de persoon
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\RelatieBiccodetable
     */
    public $biccodes;
    /**
     * Constructor method for PersooninfoRec
     * @uses PersooninfoRec::setPersoon()
     * @uses PersooninfoRec::setLeververbod()
     * @uses PersooninfoRec::setFuncties()
     * @uses PersooninfoRec::setBiccodes()
     * @param \RelatieApiV6\StructType\PersoonRec $persoon
     * @param bool $leververbod
     * @param \RelatieApiV6\StructType\RelatieFunctietable $functies
     * @param \RelatieApiV6\StructType\RelatieBiccodetable $biccodes
     */
    public function __construct(\RelatieApiV6\StructType\PersoonRec $persoon = null, $leververbod = null, \RelatieApiV6\StructType\RelatieFunctietable $functies = null, \RelatieApiV6\StructType\RelatieBiccodetable $biccodes = null)
    {
        $this
            ->setPersoon($persoon)
            ->setLeververbod($leververbod)
            ->setFuncties($functies)
            ->setBiccodes($biccodes);
    }
    /**
     * Get persoon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\PersoonRec|null
     */
    public function getPersoon()
    {
        return isset($this->persoon) ? $this->persoon : null;
    }
    /**
     * Set persoon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\PersoonRec $persoon
     * @return \RelatieApiV6\StructType\PersooninfoRec
     */
    public function setPersoon(\RelatieApiV6\StructType\PersoonRec $persoon = null)
    {
        if (is_null($persoon) || (is_array($persoon) && empty($persoon))) {
            unset($this->persoon);
        } else {
            $this->persoon = $persoon;
        }
        return $this;
    }
    /**
     * Get leververbod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getLeververbod()
    {
        return isset($this->leververbod) ? $this->leververbod : null;
    }
    /**
     * Set leververbod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $leververbod
     * @return \RelatieApiV6\StructType\PersooninfoRec
     */
    public function setLeververbod($leververbod = null)
    {
        // validation for constraint: boolean
        if (!is_null($leververbod) && !is_bool($leververbod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($leververbod, true), gettype($leververbod)), __LINE__);
        }
        if (is_null($leververbod) || (is_array($leververbod) && empty($leververbod))) {
            unset($this->leververbod);
        } else {
            $this->leververbod = $leververbod;
        }
        return $this;
    }
    /**
     * Get functies value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\RelatieFunctietable|null
     */
    public function getFuncties()
    {
        return isset($this->functies) ? $this->functies : null;
    }
    /**
     * Set functies value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\RelatieFunctietable $functies
     * @return \RelatieApiV6\StructType\PersooninfoRec
     */
    public function setFuncties(\RelatieApiV6\StructType\RelatieFunctietable $functies = null)
    {
        if (is_null($functies) || (is_array($functies) && empty($functies))) {
            unset($this->functies);
        } else {
            $this->functies = $functies;
        }
        return $this;
    }
    /**
     * Get biccodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\RelatieBiccodetable|null
     */
    public function getBiccodes()
    {
        return isset($this->biccodes) ? $this->biccodes : null;
    }
    /**
     * Set biccodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\RelatieBiccodetable $biccodes
     * @return \RelatieApiV6\StructType\PersooninfoRec
     */
    public function setBiccodes(\RelatieApiV6\StructType\RelatieBiccodetable $biccodes = null)
    {
        if (is_null($biccodes) || (is_array($biccodes) && empty($biccodes))) {
            unset($this->biccodes);
        } else {
            $this->biccodes = $biccodes;
        }
        return $this;
    }
}
