<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Netnummertable StructType
 * Meta information extracted from the WSDL
 * - documentation: Lijst met beschikbare netnummers
 * @subpackage Structs
 * @date 20240419 package
 */
class Netnummertable extends AbstractStructBase
{
    /**
     * The netnummer
     * Meta information extracted from the WSDL
     * - documentation: Netnummers
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \RelatieApiV6\StructType\NetnummerRec[]
     */
    public $netnummer;
    /**
     * Constructor method for Netnummertable
     * @uses Netnummertable::setNetnummer()
     * @param \RelatieApiV6\StructType\NetnummerRec[] $netnummer
     */
    public function __construct(array $netnummer = array())
    {
        $this
            ->setNetnummer($netnummer);
    }
    /**
     * Get netnummer value
     * @return \RelatieApiV6\StructType\NetnummerRec[]|null
     */
    public function getNetnummer()
    {
        return $this->netnummer;
    }
    /**
     * This method is responsible for validating the values passed to the setNetnummer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNetnummer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNetnummerForArrayConstraintsFromSetNetnummer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $netnummertableNetnummerItem) {
            // validation for constraint: itemType
            if (!$netnummertableNetnummerItem instanceof \RelatieApiV6\StructType\NetnummerRec) {
                $invalidValues[] = is_object($netnummertableNetnummerItem) ? get_class($netnummertableNetnummerItem) : sprintf('%s(%s)', gettype($netnummertableNetnummerItem), var_export($netnummertableNetnummerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The netnummer property can only contain items of type \RelatieApiV6\StructType\NetnummerRec, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set netnummer value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV6\StructType\NetnummerRec[] $netnummer
     * @return \RelatieApiV6\StructType\Netnummertable
     */
    public function setNetnummer(array $netnummer = array())
    {
        // validation for constraint: array
        if ('' !== ($netnummerArrayErrorMessage = self::validateNetnummerForArrayConstraintsFromSetNetnummer($netnummer))) {
            throw new \InvalidArgumentException($netnummerArrayErrorMessage, __LINE__);
        }
        $this->netnummer = $netnummer;
        return $this;
    }
    /**
     * Add item to netnummer value
     * @throws \InvalidArgumentException
     * @param \RelatieApiV6\StructType\NetnummerRec $item
     * @return \RelatieApiV6\StructType\Netnummertable
     */
    public function addToNetnummer(\RelatieApiV6\StructType\NetnummerRec $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \RelatieApiV6\StructType\NetnummerRec) {
            throw new \InvalidArgumentException(sprintf('The netnummer property can only contain items of type \RelatieApiV6\StructType\NetnummerRec, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->netnummer[] = $item;
        return $this;
    }
}
