<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getRelatiePrivacyCatsRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Ophalen van privacy categorieen van het opgegeven relatienummer, met een optionele selectie mogelijkheid op hoofd categorie en categorie.
 * @subpackage Structs
 * @date 20240419 package
 */
class GetRelatiePrivacyCatsRequest extends AbstractStructBase
{
    /**
     * The relNo
     * Meta information extracted from the WSDL
     * - documentation: Relatienummer waarvan de privacy categorieen opgehaald moet worden.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relNo;
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The hoofdCatCode
     * Meta information extracted from the WSDL
     * - documentation: Optionele selectie op hoofd privacy categorie.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $hoofdCatCode;
    /**
     * The catCode
     * Meta information extracted from the WSDL
     * - documentation: Optionele selectie op privacy categorie.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $catCode;
    /**
     * Constructor method for getRelatiePrivacyCatsRequest
     * @uses GetRelatiePrivacyCatsRequest::setRelNo()
     * @uses GetRelatiePrivacyCatsRequest::setRequestTag()
     * @uses GetRelatiePrivacyCatsRequest::setHoofdCatCode()
     * @uses GetRelatiePrivacyCatsRequest::setCatCode()
     * @param int $relNo
     * @param string $requestTag
     * @param string $hoofdCatCode
     * @param string $catCode
     */
    public function __construct($relNo = null, $requestTag = null, $hoofdCatCode = null, $catCode = null)
    {
        $this
            ->setRelNo($relNo)
            ->setRequestTag($requestTag)
            ->setHoofdCatCode($hoofdCatCode)
            ->setCatCode($catCode);
    }
    /**
     * Get relNo value
     * @return int
     */
    public function getRelNo()
    {
        return $this->relNo;
    }
    /**
     * Set relNo value
     * @param int $relNo
     * @return \RelatieApiV6\StructType\GetRelatiePrivacyCatsRequest
     */
    public function setRelNo($relNo = null)
    {
        // validation for constraint: int
        if (!is_null($relNo) && !(is_int($relNo) || ctype_digit($relNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNo, true), gettype($relNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNo) && mb_strlen(preg_replace('/(\D)/', '', $relNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNo, true), mb_strlen(preg_replace('/(\D)/', '', $relNo))), __LINE__);
        }
        $this->relNo = $relNo;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\GetRelatiePrivacyCatsRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get hoofdCatCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHoofdCatCode()
    {
        return isset($this->hoofdCatCode) ? $this->hoofdCatCode : null;
    }
    /**
     * Set hoofdCatCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hoofdCatCode
     * @return \RelatieApiV6\StructType\GetRelatiePrivacyCatsRequest
     */
    public function setHoofdCatCode($hoofdCatCode = null)
    {
        // validation for constraint: string
        if (!is_null($hoofdCatCode) && !is_string($hoofdCatCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hoofdCatCode, true), gettype($hoofdCatCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($hoofdCatCode) && mb_strlen($hoofdCatCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($hoofdCatCode)), __LINE__);
        }
        if (is_null($hoofdCatCode) || (is_array($hoofdCatCode) && empty($hoofdCatCode))) {
            unset($this->hoofdCatCode);
        } else {
            $this->hoofdCatCode = $hoofdCatCode;
        }
        return $this;
    }
    /**
     * Get catCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCatCode()
    {
        return isset($this->catCode) ? $this->catCode : null;
    }
    /**
     * Set catCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $catCode
     * @return \RelatieApiV6\StructType\GetRelatiePrivacyCatsRequest
     */
    public function setCatCode($catCode = null)
    {
        // validation for constraint: string
        if (!is_null($catCode) && !is_string($catCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($catCode, true), gettype($catCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($catCode) && mb_strlen($catCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($catCode)), __LINE__);
        }
        if (is_null($catCode) || (is_array($catCode) && empty($catCode))) {
            unset($this->catCode);
        } else {
            $this->catCode = $catCode;
        }
        return $this;
    }
}
