<?php

namespace RelatieApiV6\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getRelatieKortinggroepenResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: error47: Er zijn geen relatiekortinggroepen gevonden
 * @subpackage Structs
 * @date 20240419 package
 */
class GetRelatieKortinggroepenResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta information extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The relatieKortinggroepen
     * Meta information extracted from the WSDL
     * - documentation: Lijst met beschikbare relatiekortinggroepen
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \RelatieApiV6\StructType\RelatieKortinggroeptable
     */
    public $relatieKortinggroepen;
    /**
     * Constructor method for getRelatieKortinggroepenResponse
     * @uses GetRelatieKortinggroepenResponse::setRequestTag()
     * @uses GetRelatieKortinggroepenResponse::setRelatieKortinggroepen()
     * @param string $requestTag
     * @param \RelatieApiV6\StructType\RelatieKortinggroeptable $relatieKortinggroepen
     */
    public function __construct($requestTag = null, \RelatieApiV6\StructType\RelatieKortinggroeptable $relatieKortinggroepen = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setRelatieKortinggroepen($relatieKortinggroepen);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \RelatieApiV6\StructType\GetRelatieKortinggroepenResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get relatieKortinggroepen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \RelatieApiV6\StructType\RelatieKortinggroeptable|null
     */
    public function getRelatieKortinggroepen()
    {
        return isset($this->relatieKortinggroepen) ? $this->relatieKortinggroepen : null;
    }
    /**
     * Set relatieKortinggroepen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \RelatieApiV6\StructType\RelatieKortinggroeptable $relatieKortinggroepen
     * @return \RelatieApiV6\StructType\GetRelatieKortinggroepenResponse
     */
    public function setRelatieKortinggroepen(\RelatieApiV6\StructType\RelatieKortinggroeptable $relatieKortinggroepen = null)
    {
        if (is_null($relatieKortinggroepen) || (is_array($relatieKortinggroepen) && empty($relatieKortinggroepen))) {
            unset($this->relatieKortinggroepen);
        } else {
            $this->relatieKortinggroepen = $relatieKortinggroepen;
        }
        return $this;
    }
}
